/*
 * Decompiled with CFR 0.152.
 */
package ips.servlet.http;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameterMapHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private Map<String, String[]> parameterMap;

    public ParameterMapHttpServletRequestWrapper(HttpServletRequest request, Map<String, String[]> parameterMap) {
        super(request);
        this.parameterMap = parameterMap;
    }

    public String getParameter(String name) {
        String[] vals = this.parameterMap.get(name);
        if (vals == null || vals.length == 0) {
            return null;
        }
        return vals[0];
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public Enumeration<String> getParameterNames() {
        Hashtable<String, String[]> ht = new Hashtable<String, String[]>(this.parameterMap);
        return ht.keys();
    }

    public String[] getParameterValues(String name) {
        Collection<String[]> paramValsColl = this.parameterMap.values();
        int size = paramValsColl.size();
        return paramValsColl.toArray(new String[size]);
    }
}

