/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.RelationshipException;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;

public class RelationshipURL {
    private BeanProperty beanProperty = null;
    private Object bean = null;

    public RelationshipURL(BeanProperty beanProperty) {
        this.beanProperty = beanProperty;
    }

    public RelationshipURL(Object bean) {
        this.bean = bean;
    }

    public EditableURI getEditableURI(String action) throws RelationshipException {
        EditableURI uri = null;
        if (action == null) {
            throw new NullPointerException("No action base URL given!");
        }
        try {
            if (this.bean != null) {
                ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(this.bean.getClass(), true);
                PersistenceObjectIdentifier selfPoi = relBeanInfo.getPersistenceObjectIdentifier(this.bean);
                if (selfPoi != null) {
                    uri = new EditableURI(action);
                    uri.appendQueryMap(selfPoi.toQueryMap());
                    uri.appendQuery("_cmd", (Object)"view");
                }
            } else {
                PropertyDescriptor pd = this.beanProperty.getPropertyDescriptor();
                Class<?> propType = pd.getPropertyType();
                Object bean = this.beanProperty.getBeanModel().getBean();
                ExtBeanInfo beanInfo = this.beanProperty.getBeanProvider().getBeanInfo();
                Method rm = pd.getReadMethod();
                Object relValue = rm.invoke(bean, new Object[0]);
                if (relValue != null) {
                    String mappedBy = null;
                    if (Collection.class.isAssignableFrom(propType)) {
                        uri = new EditableURI(action);
                        uri.appendQuery("_cmd", (Object)"list_related");
                        ManyToMany manyToManyAnno = rm.getAnnotation(ManyToMany.class);
                        if (manyToManyAnno != null) {
                            mappedBy = manyToManyAnno.mappedBy();
                        } else {
                            OneToMany oneToManyAnno = rm.getAnnotation(OneToMany.class);
                            if (oneToManyAnno != null) {
                                mappedBy = oneToManyAnno.mappedBy();
                            }
                        }
                        if (mappedBy != null && !mappedBy.equals("")) {
                            uri.appendQuery("_related_mappedby", (Object)mappedBy);
                        } else {
                            uri.appendQuery("_related_prop", (Object)pd.getName());
                        }
                        PersistenceObjectIdentifier poi = beanInfo.getPersistenceObjectIdentifier(bean);
                        uri.appendQueryMap(poi.toQueryMap());
                    } else {
                        ExtBeanInfo relBeanInfo = PersistenceIntrospector.getPersistenceBeanInfo(propType, true);
                        PersistenceObjectIdentifier relPoi = relBeanInfo.getPersistenceObjectIdentifier(relValue);
                        if (relPoi != null) {
                            uri = new EditableURI(action);
                            uri.appendQueryMap(relPoi.toQueryMap());
                            uri.appendQuery("_cmd", (Object)"view");
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new RelationshipException(e);
        }
        return uri;
    }
}

