/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ipsk.webapps.ControllerException;
import java.security.SecureRandom;
import java.util.Base64;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class SecureRequestTokenProvider {
    public static final int SECURE_REQUEST_TOKEN_BYTE_LEN = 64;
    public static final String SECURE_REQUEST_TOKEN_NAME = "_secureRequestToken";
    public static final String SECURE_REQUEST_TOKEN_ATTR_KEY = SecureRequestTokenProvider.class.getName() + "._secureRequestToken";

    public static String generateSecureRequestToken(HttpServletRequest req) {
        return SecureRequestTokenProvider.generateSecureRequestToken(req, true);
    }

    public static String generateSecureRequestToken(HttpServletRequest req, boolean create) {
        String secureToken = null;
        HttpSession sess = req.getSession();
        if (sess != null) {
            Object secToksSetObj = sess.getAttribute(SECURE_REQUEST_TOKEN_ATTR_KEY);
            if (secToksSetObj != null && secToksSetObj instanceof String) {
                secureToken = (String)secToksSetObj;
            }
            if (secureToken == null) {
                SecureRandom sr = new SecureRandom();
                byte[] bytes = new byte[64];
                sr.nextBytes(bytes);
                Base64.Encoder b64Enc = Base64.getUrlEncoder().withoutPadding();
                secureToken = b64Enc.encodeToString(bytes);
                sess.setAttribute(SECURE_REQUEST_TOKEN_ATTR_KEY, (Object)secureToken);
            }
        }
        return secureToken;
    }

    private boolean _checkSecureRequestToken(HttpServletRequest req) {
        String secureToken;
        String secReqTokSent = req.getParameter(SECURE_REQUEST_TOKEN_NAME);
        if (secReqTokSent != null && (secureToken = SecureRequestTokenProvider.generateSecureRequestToken(req, false)) != null) {
            return secureToken.equals(secReqTokSent);
        }
        return false;
    }

    public void checkSecureRequestToken(HttpServletRequest req) throws ControllerException {
        boolean res = this._checkSecureRequestToken(req);
        if (!res) {
            throw new ControllerException("Invalid request!");
        }
    }
}

