/*
 * Decompiled with CFR 0.152.
 */
package ipsk.persistence;

import ipsk.persistence.EntityManagerProvider;
import ipsk.webapps.EntityManagerFactoryInitializer;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;

public class EntityManagerProviderImpl
implements EntityManagerProvider {
    private EntityManagerThreadLocal emtl = new EntityManagerThreadLocal();

    @Override
    public EntityManager getThreadEntityManager() {
        if (this.emtl == null) {
            this.emtl = new EntityManagerThreadLocal();
        }
        return (EntityManager)this.emtl.get();
    }

    public void removeEntityManagerThreadLocal() {
        if (this.emtl != null) {
            this.emtl.remove();
        }
    }

    public EntityManager getEntityManager() {
        return EntityManagerFactoryInitializer.getEntityManagerFactory().createEntityManager();
    }

    public class EntityManagerThreadLocal
    extends ThreadLocal<EntityManager> {
        @Override
        protected synchronized EntityManager initialValue() {
            EntityManager em = null;
            EntityManagerFactory emf = EntityManagerFactoryInitializer.getEntityManagerFactory();
            if (emf != null) {
                em = emf.createEntityManager();
            }
            return em;
        }
    }
}

