/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.servlet.http.URLEncoder;
import ipsk.beans.BeanModel;
import ipsk.beans.form.FormConfiguration;
import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertyIterator;
import ipsk.jsp.taglib.beans.BeanPropertyProvider;
import ipsk.jsp.taglib.beans.RelationshipException;
import ipsk.jsp.taglib.beans.RelationshipURL;
import ipsk.net.EditableURI;
import ipsk.text.html.HTMLTextEncoder;
import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.Tag;

public class BeanPropertyRelatedURLTag
extends ExtBodyTagSupport
implements BeanPropertyIterator {
    private String action;
    private String property;
    private Object bean;
    private BeanProperty beanProperty;
    private BeanPropertyProvider beanPropertyProvider;
    private BeanModel<Object> beanModel;
    private ExtBeanInfo beanInfo;

    @Override
    public void setPageContext(PageContext pc) {
        super.setPageContext(pc);
    }

    public void setParent(Tag parent) {
        Tag bpParent;
        super.setParent(parent);
        for (bpParent = parent; bpParent != null && !(bpParent instanceof BeanPropertyProvider); bpParent = bpParent.getParent()) {
        }
        if (bpParent != null && bpParent instanceof BeanPropertyProvider) {
            this.beanPropertyProvider = (BeanPropertyProvider)bpParent;
        }
    }

    @Override
    public int doStartTag() throws JspException {
        RelationshipURL relURL = null;
        if (this.property != null && this.bean != null) {
            this.beanProperty = new BeanProperty(this.property);
            this.beanModel = new BeanModel(this.bean);
            try {
                this.beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(this.bean.getClass(), true);
                this.beanProperty.setContext(this);
                relURL = new RelationshipURL(this.beanProperty);
            }
            catch (Exception e1) {
                e1.printStackTrace();
                throw new JspException((Throwable)e1);
            }
        } else if (this.bean != null) {
            relURL = new RelationshipURL(this.bean);
        } else if (this.beanPropertyProvider != null) {
            this.beanProperty = this.beanPropertyProvider.getBeanProperty();
            relURL = new RelationshipURL(this.beanProperty);
        } else {
            throw new JspException("No bean found! Please set attribute 'bean'");
        }
        String uri = null;
        try {
            EditableURI eUri = relURL.getEditableURI(this.action);
            uri = eUri.getUri();
        }
        catch (RelationshipException e) {
            e.printStackTrace();
            throw new JspException((Throwable)e);
        }
        JspWriter out = this.pageContext.getOut();
        String encodedUrl = URLEncoder.encodeURL(this.pageContext, uri);
        String htmlEncodedURL = HTMLTextEncoder.encode((String)encodedUrl);
        try {
            out.print(htmlEncodedURL);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JspException((Throwable)e);
        }
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        return 6;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public Object getBean() {
        return this.bean;
    }

    public void setBean(Object bean) {
        this.bean = bean;
    }

    @Override
    public String getActionCommand() {
        return null;
    }

    @Override
    public String[] getAdditionalPropertyNames() {
        return null;
    }

    @Override
    public BeanModel getBeanModel() {
        return this.beanModel;
    }

    @Override
    public String getCurrentProperty() {
        return this.property;
    }

    @Override
    public PageContext getPageContext() {
        return this.pageContext;
    }

    @Override
    public void setCurrentPropertyDone(boolean b) {
    }

    @Override
    public ExtBeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    @Override
    public FormConfiguration getFormConfiguration() {
        return null;
    }

    @Override
    public BeanPropertyIterator.Iteration getIteration() {
        return BeanPropertyIterator.Iteration.TABLE;
    }
}

