/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans;

import ips.beans.ExtBeanInfo;
import ipsk.lang.reflect.NativeTypeWrapper;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.util.EnumResourceKeys;
import ipsk.util.MemberResourceKey;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.jstl.fmt.LocaleSupport;

public class BeanPropertyValueText {
    private ExtBeanInfo beanInfo;
    public static final String DEF_COLL_SEP_STRING = ",";
    public static final String RESOURCE_KEY_TRUE = "yes";
    public static final String RESOURCE_KEY_FALSE = "no";
    private PageContext pageContext;
    private Locale locale;
    private int dateStyle = 2;
    private int timeStyle = 2;
    private int maxListLength = 0;
    private String listSeparatorString = ",";

    public BeanPropertyValueText(ExtBeanInfo beanInfo, PageContext pageContext) {
        this.beanInfo = beanInfo;
        this.pageContext = pageContext;
        this.locale = ipsk.jsp.fmt.LocaleSupport.getLocale(pageContext);
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    public BeanPropertyValueText(ExtBeanInfo beanInfo, PageContext pageContext, int maxNumberOfDisplayCollMembers) {
        this.beanInfo = beanInfo;
        this.pageContext = pageContext;
        this.maxListLength = maxNumberOfDisplayCollMembers;
        this.locale = ipsk.jsp.fmt.LocaleSupport.getLocale(pageContext);
        if (this.locale == null) {
            this.locale = Locale.getDefault();
        }
    }

    public boolean isEmpty(PropertyDescriptor pd, Object value) {
        Class<?> propType;
        if (value == null) {
            return true;
        }
        if (pd != null && Collection.class.isAssignableFrom(propType = pd.getPropertyType()) && value instanceof Collection) {
            Collection coll = (Collection)value;
            int elementCount = 0;
            if (coll != null) {
                elementCount = coll.size();
                return elementCount == 0;
            }
        }
        return false;
    }

    public String getValueTextRepresentation(PropertyDescriptor pd, Object value) {
        String valStr = "";
        if (value == null) {
            return valStr;
        }
        if (pd != null) {
            Class<?> propType = pd.getPropertyType();
            Temporal dateTemporal = pd.getReadMethod().getAnnotation(Temporal.class);
            if (value instanceof PersistenceObjectIdentifier) {
                return ((PersistenceObjectIdentifier)value).getIdObject().toString();
            }
            if (Collection.class.isAssignableFrom(propType)) {
                Collection coll = (Collection)value;
                int elementCount = 0;
                if (value != null) {
                    elementCount = coll.size();
                }
                if (elementCount != 0 && elementCount <= this.maxListLength) {
                    Iterator it = coll.iterator();
                    StringBuffer sb = new StringBuffer();
                    while (it.hasNext()) {
                        sb.append(it.next().toString());
                        if (!it.hasNext()) continue;
                        sb.append(this.listSeparatorString);
                    }
                    return sb.toString();
                }
                return "#" + elementCount;
            }
            if (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class)) {
                if (value.equals(true)) {
                    return LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)RESOURCE_KEY_TRUE, (String)"ipsk.jsp.Messages");
                }
                if (value.equals(false)) {
                    return LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)RESOURCE_KEY_FALSE, (String)"ipsk.jsp.Messages");
                }
            } else {
                String valueStr;
                if (propType.isEnum()) {
                    Enum enumVal = (Enum)value;
                    String enumMemberName = enumVal.name();
                    String message = enumVal.toString();
                    EnumResourceKeys reskeysAnno = propType.getAnnotation(EnumResourceKeys.class);
                    if (reskeysAnno != null) {
                        for (MemberResourceKey memberResKeyAnno : reskeysAnno.memberResourceKeys()) {
                            if (!memberResKeyAnno.name().equals(enumMemberName)) continue;
                            String resourceKey = memberResKeyAnno.key();
                            if (resourceKey == null) break;
                            message = LocaleSupport.getLocalizedMessage((PageContext)this.pageContext, (String)resourceKey, (String)this.beanInfo.getResourceBundleName());
                            break;
                        }
                    }
                    return message;
                }
                if (NativeTypeWrapper.isPrimitiveNumber(propType) || Number.class.isAssignableFrom(propType)) {
                    PropertyDescriptor idPd = this.beanInfo.getIdPropertyDescriptor();
                    if (idPd != null && idPd.equals(pd)) {
                        return value.toString();
                    }
                    NumberFormat nf = NumberFormat.getInstance(this.locale);
                    return nf.format(value);
                }
                if (Date.class.isAssignableFrom(propType)) {
                    if (value != null) {
                        Date date = (Date)value;
                        DateFormat dateFormat = null;
                        dateFormat = dateTemporal != null && dateTemporal.value().equals((Object)TemporalType.DATE) ? DateFormat.getDateInstance(this.dateStyle, this.locale) : DateFormat.getDateTimeInstance(this.dateStyle, this.timeStyle, this.locale);
                        valStr = dateFormat.format(date);
                    }
                } else if (value != null && (valueStr = value.toString()) != null) {
                    valStr = valueStr;
                }
            }
        }
        return valStr;
    }

    public boolean isCollection(PropertyDescriptor pd) {
        Class<?> propType = pd.getPropertyType();
        return Collection.class.isAssignableFrom(propType);
    }

    public boolean isEmpty(Object bean, PropertyDescriptor pd) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method rm = pd.getReadMethod();
        Object value = rm.invoke(bean, new Object[0]);
        return this.isEmpty(pd, value);
    }

    public String getValueTextRepresentation(Object bean, PropertyDescriptor pd) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Method rm = pd.getReadMethod();
        Object value = rm.invoke(bean, new Object[0]);
        return this.getValueTextRepresentation(pd, value);
    }
}

