/*
 * Decompiled with CFR 0.152.
 */
package ipsk.jsp.taglib.beans.table;

import ipsk.jsp.taglib.ExtBodyTagSupport;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertyProvider;
import ipsk.jsp.taglib.beans.table.BeanPropertyTableCol;
import ipsk.jsp.taglib.beans.table.BeanTableCol;
import ipsk.jsp.taglib.beans.table.BeanTableTag;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;

public class BeanTableColTag
extends ExtBodyTagSupport
implements BeanPropertyProvider {
    private BeanTableTag beanTableParentTag;
    private String name;
    private String bundle;
    private String key;
    private String href;
    private String queryName;
    private String var;
    private String hrefVar;
    private String valueCssClass = null;
    protected int maxTextLength = -1;
    protected int maxListLength = 0;
    private BeanProperty beanProperty;

    @Override
    public String getBundle() {
        return this.bundle;
    }

    @Override
    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    public String getValueCssClass() {
        return this.valueCssClass;
    }

    public void setValueCssClass(String valueCssClass) {
        this.valueCssClass = valueCssClass;
    }

    public int getMaxTextLength() {
        return this.maxTextLength;
    }

    public void setMaxTextLength(int maxTextLength) {
        this.maxTextLength = maxTextLength;
    }

    public void setParent(Tag parent) {
        super.setParent(parent);
        if (parent instanceof BeanTableTag) {
            this.beanTableParentTag = (BeanTableTag)parent;
        }
    }

    @Override
    public int doStartTag() throws JspException {
        if (this.beanTableParentTag == null) {
            throw new JspException("Table column tag must be inside table tag body.");
        }
        BeanTableCol tableCol = this.beanTableParentTag.getColumn(this.name);
        BeanTableTag.RowStatus rowStatus = this.beanTableParentTag.getRowStatus();
        String currProp = this.beanTableParentTag.getCurrentProperty();
        if (rowStatus == BeanTableTag.RowStatus.TAGS) {
            if (this.bundle != null) {
                tableCol.setBundle(this.bundle);
            }
            if (this.key != null) {
                tableCol.setKey(this.key);
            }
            if (tableCol instanceof BeanPropertyTableCol) {
                BeanPropertyTableCol bptc = (BeanPropertyTableCol)tableCol;
                bptc.setVar(this.var);
                bptc.setQueryName(this.queryName);
                bptc.setHref(this.href);
                bptc.setMaxListLength(this.maxListLength);
                bptc.setValueCssClass(this.valueCssClass);
                bptc.setMaxTextLength(this.maxTextLength);
                this.beanProperty = bptc.getBeanProperty();
            }
        } else if (rowStatus == BeanTableTag.RowStatus.DATA && currProp != null && currProp.equals(this.name)) {
            if (tableCol == null) {
                return 1;
            }
            if (tableCol instanceof BeanPropertyTableCol) {
                BeanPropertyTableCol bptc = (BeanPropertyTableCol)tableCol;
                String var = bptc.getVar();
                if (var != null) {
                    PropertyDescriptor pd = bptc.getBeanProperty().getPropertyDescriptor();
                    Object item = this.beanTableParentTag.getItem();
                    Method rm = pd.getReadMethod();
                    Object value = null;
                    try {
                        value = rm.invoke(item, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new JspException((Throwable)e);
                    }
                    this.pageContext.setAttribute(var, value, 2);
                    if (this.hrefVar != null) {
                        String hrefValue = null;
                        try {
                            hrefValue = bptc.getEncodedHrefUri(item);
                        }
                        catch (Exception e) {
                            throw new JspException((Throwable)e);
                        }
                        this.pageContext.setAttribute(this.hrefVar, (Object)hrefValue, 2);
                    }
                    return 1;
                }
            } else {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int doEndTag() throws JspException {
        return 6;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        BeanTableCol tableCol = this.beanTableParentTag.getColumn(name);
        if (tableCol instanceof BeanPropertyTableCol) {
            BeanPropertyTableCol bptc = (BeanPropertyTableCol)tableCol;
            this.beanProperty = bptc.getBeanProperty();
        }
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public int getMaxListLength() {
        return this.maxListLength;
    }

    public void setMaxListLength(int maxListLength) {
        this.maxListLength = maxListLength;
    }

    public String getQueryName() {
        return this.queryName;
    }

    public void setQueryName(String namedQuery) {
        this.queryName = namedQuery;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    @Override
    public BeanProperty getBeanProperty() {
        return this.beanProperty;
    }

    public String getHrefVar() {
        return this.hrefVar;
    }

    public void setHrefVar(String hrefVar) {
        this.hrefVar = hrefVar;
    }
}

