/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.jsp.fmt.LocaleSupport;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.text.StringObjectConverter;
import ipsk.text.ParserException;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class BoolExprQueryParser {
    public static final String IS_KEY = "is_key";
    public static final String NE_KEY = "ne_key";
    public static final String IS = "is";
    public static final String NE = "ne";
    public static final String CONTAINS = "contains";
    public static final String STARTS = "starts";
    public static final String ENDS = "ends";
    public static final String GT = "gt";
    public static final String LT = "lt";
    public static final String GE = "ge";
    public static final String LE = "le";
    public static final String EQUALS = "equals";
    public static final String MEMBER = "member";
    public static final String EQUALS_NOT = "equals_not";
    public static final String NOT_MEMBER = "not_member";
    public static final String BOUND = "bound";
    public static final String NOT_BOUND = "not_bound";
    public static final String CASE_INSENSITIVE_VAL = "insensitive";
    protected Hashtable<String, String> ht = null;
    protected ServletRequest req = null;
    protected Class<?> beanClass = null;
    protected PropertyDescriptor[] beanProperties = null;
    private Locale locale = null;

    public BoolExprQueryParser(ServletRequest req) {
        this.req = req;
    }

    public BoolExprQueryParser(ServletRequest req, Class beanClass) throws ParserException {
        this(req, beanClass, null);
        String localeStr = req.getParameter("_locale");
        if (localeStr != null) {
            this.locale = LocaleSupport.parse(localeStr);
        }
        if (this.locale == null) {
            this.locale = LocaleSupport.getLocale(req);
        }
        if (this.locale == null && req instanceof HttpServletRequest) {
            this.locale = ((HttpServletRequest)req).getLocale();
        }
    }

    public BoolExprQueryParser(ServletRequest req, Class beanClass, Locale locale) throws ParserException {
        BeanInfo beanInfo;
        this.req = req;
        this.beanClass = beanClass;
        this.locale = locale;
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e1) {
            throw new ParserException((Throwable)e1);
        }
        this.beanProperties = beanInfo.getPropertyDescriptors();
    }

    public BoolExprQueryParser(Hashtable<String, String> ht) {
        this.ht = ht;
    }

    public ExtBoolExpr parse() throws ParserException {
        ExtBoolExpr retVal = null;
        retVal = this.parseCondition(0);
        if (retVal == null) {
            String op0 = this.getParameter("_ec0");
            if (op0 == null || op0.equals("")) {
                return null;
            }
            String o0 = this.getParameter("_eo0");
            if (o0 == null || o0.equals("")) {
                return null;
            }
            retVal = this.parseExpression(0);
        }
        return retVal;
    }

    private String getParameter(String paramName) {
        if (this.req != null) {
            return this.req.getParameter(paramName);
        }
        if (this.ht != null) {
            String o = this.ht.get(paramName);
            if (o == null) {
                return null;
            }
            return ((String[])o)[0];
        }
        return null;
    }

    private ExtBoolExpr parseCondition(int index) throws ParserException {
        String c = this.getParameter("_c" + index);
        if (c == null) {
            return null;
        }
        ExtBoolExpr retVal = new ExtBoolExpr();
        StringTokenizer st = new StringTokenizer(c, "_");
        String co1 = st.nextToken();
        int ind = Integer.parseInt(co1.substring(1));
        if (co1.startsWith("e")) {
            retVal.setOperand0((Object)this.parseExpression(ind));
        } else if (co1.startsWith("c")) {
            retVal.setOperand0((Object)this.parseCondition(ind));
        } else {
            throw new ParserException();
        }
        if (!st.hasMoreTokens()) {
            return retVal;
        }
        String coo = st.nextToken();
        String co2 = st.nextToken();
        int ind2 = Integer.parseInt(co2.substring(1));
        if (co2.startsWith("e")) {
            retVal.setOperand1((Object)this.parseExpression(ind2));
        } else if (co2.startsWith("c")) {
            retVal.setOperand1((Object)this.parseCondition(ind2));
        } else {
            throw new ParserException();
        }
        if (retVal != null) {
            retVal.setOperator((Object)coo);
            if (retVal.getOperand0() == null) {
                retVal = (ExtBoolExpr)retVal.getOperand1();
            } else if (retVal.getOperand1() == null) {
                retVal = (ExtBoolExpr)retVal.getOperand0();
            }
        }
        return retVal;
    }

    private ExtBoolExpr parseExpression(int ind) throws ParserException {
        boolean caseInSensitive;
        String op0 = this.getParameter("_ec" + ind);
        String opr = this.getParameter("_eo" + ind);
        if (op0 == null || opr == null || op0.equals("") || opr.equals("")) {
            return null;
        }
        ExtBoolExpr retVal = new ExtBoolExpr();
        String op1 = this.getParameter("_ev" + ind);
        if (op0 == null || opr == null || op1 == null) {
            throw new ParserException();
        }
        String boolOp = BoolExprQueryParser.getBoolExprOperator(opr);
        Class<?> propertyType = null;
        Object op1Val = op1;
        String caseInsensitiveParam = this.getParameter("_eci" + ind);
        boolean bl = caseInSensitive = caseInsensitiveParam != null && caseInsensitiveParam.equals(CASE_INSENSITIVE_VAL);
        if (this.beanClass != null && this.beanProperties != null) {
            for (PropertyDescriptor pd : this.beanProperties) {
                if (!pd.getName().equals(op0)) continue;
                propertyType = pd.getPropertyType();
                if (!ExtBoolExpr.isOperatorSupportingType((Object)boolOp, propertyType)) {
                    throw new ParserException("Operator does not support " + propertyType.getName());
                }
                try {
                    if (propertyType.isEnum()) {
                        if (ExtBoolExpr.isKeyOperator((Object)boolOp)) {
                            op1Val = StringObjectConverter.stringToObject(op1, pd, this.locale, true, false);
                            continue;
                        }
                        op1Val = StringObjectConverter.stringToObject(op1, pd, this.locale, false, true);
                        continue;
                    }
                    op1Val = StringObjectConverter.stringToObject(op1, pd, this.locale);
                }
                catch (ParserException e) {
                    throw new ParserException((Throwable)e);
                }
            }
        }
        if (propertyType != null && propertyType.equals(String.class)) {
            retVal.setCaseInSensitive(caseInSensitive);
        }
        retVal.setOperand0((Object)op0);
        retVal.setOperator((Object)boolOp);
        retVal.setOperand1(op1Val);
        return retVal;
    }

    public static String getQueryOperator(Object extBoolOperator) {
        if (extBoolOperator == null) {
            return "";
        }
        if (extBoolOperator.equals(ExtBoolExpr.EQUAL_KEY)) {
            return IS_KEY;
        }
        if (extBoolOperator.equals(ExtBoolExpr.NOT_EQUAL_KEY)) {
            return NE_KEY;
        }
        if (extBoolOperator.equals(ExtBoolExpr.EQUAL)) {
            return IS;
        }
        if (extBoolOperator.equals(ExtBoolExpr.NOT_EQUAL)) {
            return NE;
        }
        if (extBoolOperator.equals(ExtBoolExpr.CONTAINS)) {
            return CONTAINS;
        }
        if (extBoolOperator.equals("(starts with)")) {
            return STARTS;
        }
        if (extBoolOperator.equals("(ends with)")) {
            return ENDS;
        }
        if (extBoolOperator.equals(">")) {
            return GT;
        }
        if (extBoolOperator.equals("<")) {
            return LT;
        }
        if (extBoolOperator.equals(">=")) {
            return GE;
        }
        if (extBoolOperator.equals("<=")) {
            return LE;
        }
        if (extBoolOperator.equals(ExtBoolExpr.EQUALS)) {
            return EQUALS;
        }
        if (extBoolOperator.equals(ExtBoolExpr.MEMBER)) {
            return MEMBER;
        }
        if (extBoolOperator.equals(ExtBoolExpr.EQUALS_NOT)) {
            return EQUALS_NOT;
        }
        if (extBoolOperator.equals(ExtBoolExpr.NOT_MEMBER)) {
            return NOT_MEMBER;
        }
        if (extBoolOperator.equals(ExtBoolExpr.BOUND)) {
            return BOUND;
        }
        if (extBoolOperator.equals(ExtBoolExpr.NOT_BOUND)) {
            return NOT_BOUND;
        }
        return null;
    }

    public static String getBoolExprOperator(String queryOperator) {
        if (queryOperator == null) {
            return ExtBoolExpr.EQUAL;
        }
        if (queryOperator.equals(IS_KEY)) {
            return ExtBoolExpr.EQUAL_KEY;
        }
        if (queryOperator.equals(NE_KEY)) {
            return ExtBoolExpr.NOT_EQUAL_KEY;
        }
        if (queryOperator.equals(IS)) {
            return ExtBoolExpr.EQUAL;
        }
        if (queryOperator.equals(NE)) {
            return ExtBoolExpr.NOT_EQUAL;
        }
        if (queryOperator.equals(CONTAINS)) {
            return ExtBoolExpr.CONTAINS;
        }
        if (queryOperator.equals(STARTS)) {
            return "(starts with)";
        }
        if (queryOperator.equals(ENDS)) {
            return "(ends with)";
        }
        if (queryOperator.equals(GT)) {
            return ">";
        }
        if (queryOperator.equals(LT)) {
            return "<";
        }
        if (queryOperator.equals(GE)) {
            return ">=";
        }
        if (queryOperator.equals(LE)) {
            return "<=";
        }
        if (queryOperator.equals(EQUALS)) {
            return ExtBoolExpr.EQUALS;
        }
        if (queryOperator.equals(MEMBER)) {
            return ExtBoolExpr.MEMBER;
        }
        if (queryOperator.equals(EQUALS_NOT)) {
            return ExtBoolExpr.EQUALS_NOT;
        }
        if (queryOperator.equals(NOT_MEMBER)) {
            return ExtBoolExpr.NOT_MEMBER;
        }
        if (queryOperator.equals(BOUND)) {
            return ExtBoolExpr.BOUND;
        }
        if (queryOperator.equals(NOT_BOUND)) {
            return ExtBoolExpr.NOT_BOUND;
        }
        return null;
    }
}

