/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PutServlet
extends HttpServlet {
    private static final boolean DEBUG = false;
    protected static final int DEFAULT_BUFSIZE = 2048;
    protected int bufSize = 2048;
    protected byte[] buf = new byte[this.bufSize];
    protected InputStream is;
    protected OutputStream os;
    protected FileOutputStream fos;
    protected FileInputStream fis;

    protected synchronized void doPut(HttpServletRequest req, HttpServletResponse res) throws IOException {
        String relServletPath = req.getServletPath();
        ServletContext sc = this.getServletContext();
        String recsDir = sc.getInitParameter("recsDir");
        Enumeration params = sc.getInitParameterNames();
        String rPath = new String(recsDir + File.separator + relServletPath);
        File f = new File(rPath);
        File pd = f.getParentFile();
        boolean created = false;
        if (!pd.exists()) {
            created = pd.mkdirs();
        }
        if (created) {
            this.log("Directory " + pd.getName() + " for user '" + req.getRemoteUser() + "' created.");
        }
        this.is = req.getInputStream();
        this.fos = new FileOutputStream(f);
        int read = 0;
        try {
            do {
                if ((read = this.is.read(this.buf, 0, this.bufSize)) <= 0) continue;
                this.fos.write(this.buf, 0, read);
            } while (read >= 0);
            this.log("File '" + f.getAbsolutePath() + "' written for user '" + req.getRemoteUser() + "' written.");
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (this.fos != null) {
                this.fos.close();
            }
        }
    }

    protected synchronized void doGet(HttpServletRequest req, HttpServletResponse res) throws IOException {
        ServletContext sc = this.getServletContext();
        String relServletPath = req.getServletPath();
        String recsDir = sc.getInitParameter("recsDir");
        String rPath = new String(recsDir + File.separator + relServletPath);
        File f = new File(rPath);
        try {
            this.os = res.getOutputStream();
            this.fis = new FileInputStream(f);
            int read = 0;
            do {
                if ((read = this.fis.read(this.buf, 0, this.bufSize)) <= 0) continue;
                try {
                    this.os.write(this.buf, 0, read);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            } while (read >= 0);
        }
        catch (FileNotFoundException fnfe) {
            res.sendError(404);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (this.fis != null) {
                this.fis.close();
            }
        }
    }
}

