/*
 * Decompiled with CFR 0.152.
 */
package ipsk.persistence;

import ipsk.math.bool.BoolExpr;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.PersistenceBoolExpr;
import ipsk.persistence.PersistenceObjectIdentifier;
import java.util.ArrayList;
import java.util.Locale;
import javax.persistence.EntityManager;

public class PersistenceBoolExprConverter {
    public static final String JPQL_PARAM_NAME_PREFIX = "persistenceboolexprconverter";
    private BoolExpr boolExpr;
    private String jpqlSelectExpression = null;

    public PersistenceBoolExprConverter(String jpqlSelectExpression) {
        this.jpqlSelectExpression = jpqlSelectExpression;
    }

    public PersistenceBoolExprConverter(BoolExpr boolExpr, String jpqlSelectExpression) {
        this(jpqlSelectExpression);
        this.boolExpr = boolExpr;
    }

    public PersistenceBoolExpr createQueryData() {
        return this.createQueryData(null, this.boolExpr, 0);
    }

    public PersistenceBoolExpr createQueryData(int paramCountOffset) {
        return this.createQueryData(null, this.boolExpr, paramCountOffset);
    }

    public PersistenceBoolExpr createQueryData(EntityManager em) {
        return this.createQueryData(em, this.boolExpr, 0);
    }

    public PersistenceBoolExpr createQueryData(EntityManager em, int paramCountOffset) {
        return this.createQueryData(em, this.boolExpr, paramCountOffset);
    }

    public PersistenceBoolExpr createQueryData(EntityManager em, BoolExpr e, int paramCountOffset) {
        return this.createQueryData(em, e, new ArrayList<Object>(), paramCountOffset);
    }

    private String escapeSQLLikeChars(Object param) {
        String paramStr = param.toString();
        String escParamStr = paramStr.replace("%", "\\%").replace("_", "\\_");
        return escParamStr;
    }

    private PersistenceBoolExpr createQueryData(EntityManager em, BoolExpr e, ArrayList<Object> vars, int paramCountOffset) {
        ExtBoolExpr ee;
        String pqlWhere = "";
        Object jpqlSelect = "";
        Object operand0 = e.getOperand0();
        boolean caseInSensitive = false;
        if (e instanceof ExtBoolExpr && (ee = (ExtBoolExpr)e).isCaseInSensitive()) {
            caseInSensitive = true;
        }
        if (operand0 != null) {
            if (operand0 instanceof BoolExpr) {
                PersistenceBoolExpr tPqd = this.createQueryData(em, (BoolExpr)operand0, vars, paramCountOffset);
                pqlWhere = pqlWhere.concat("( " + tPqd.getConditionalExpression() + " )");
            } else if (operand0 instanceof String) {
                jpqlSelect = new String(this.jpqlSelectExpression + "." + (String)operand0);
                if (caseInSensitive) {
                    jpqlSelect = "LOWER(" + (String)jpqlSelect + ")";
                }
            }
            Object operator = e.getOperator();
            if (operator == null) {
                pqlWhere = "";
            } else {
                Object operand1 = e.getOperand1();
                Object param = null;
                if (operand1 instanceof PersistenceObjectIdentifier) {
                    PersistenceObjectIdentifier poi = (PersistenceObjectIdentifier)operand1;
                    param = em.find(poi.getTargetClass(), poi.getIdObject());
                } else {
                    param = operand1;
                }
                String paramName = null;
                if (param != null && param instanceof String && caseInSensitive) {
                    param = ((String)param).toLowerCase(Locale.ENGLISH);
                }
                boolean valueSet = false;
                if (operator.equals("(starts with)")) {
                    vars.add(this.escapeSQLLikeChars(param) + "%");
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat((String)jpqlSelect + " LIKE :" + paramName + " ");
                    valueSet = true;
                } else if (operator.equals("(ends with)")) {
                    vars.add("%" + this.escapeSQLLikeChars(param));
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat((String)jpqlSelect + " LIKE :" + paramName + " ");
                    valueSet = true;
                } else if (operator.equals(ExtBoolExpr.CONTAINS)) {
                    vars.add("%" + this.escapeSQLLikeChars(param) + "%");
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat((String)jpqlSelect + " LIKE :" + paramName + " ");
                    valueSet = true;
                } else if (operator.equals(ExtBoolExpr.MEMBER)) {
                    vars.add(param);
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat(" :" + paramName + " MEMBER OF " + (String)jpqlSelect);
                    valueSet = true;
                } else if (operator.equals(ExtBoolExpr.EQUALS)) {
                    vars.add(param);
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat(" " + (String)jpqlSelect + " = :" + paramName);
                    valueSet = true;
                } else if (operator.equals(ExtBoolExpr.NOT_MEMBER)) {
                    vars.add(param);
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat(" :" + paramName + " NOT MEMBER OF " + (String)jpqlSelect);
                    valueSet = true;
                } else if (operator.equals(ExtBoolExpr.EQUALS_NOT)) {
                    vars.add(param);
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat(" (" + (String)jpqlSelect + " IS NULL) OR (" + (String)jpqlSelect + " <> :" + paramName + ")");
                    valueSet = true;
                } else if (operator.equals(ExtBoolExpr.BOUND)) {
                    pqlWhere = pqlWhere.concat(" (" + (String)jpqlSelect + " IS NOT NULL) ");
                    valueSet = true;
                } else if (operator.equals(ExtBoolExpr.NOT_BOUND)) {
                    pqlWhere = pqlWhere.concat(" (" + (String)jpqlSelect + " IS NULL) ");
                    valueSet = true;
                } else {
                    pqlWhere = pqlWhere.concat((String)jpqlSelect + " " + operator + " ");
                }
                if (param instanceof BoolExpr) {
                    PersistenceBoolExpr tPqd = this.createQueryData(em, (BoolExpr)param, vars, paramCountOffset);
                    pqlWhere = pqlWhere.concat("( " + tPqd.getConditionalExpression() + " )");
                } else if (!valueSet) {
                    vars.add(param);
                    paramName = "persistenceboolexprconverter_" + (vars.size() + paramCountOffset);
                    pqlWhere = pqlWhere.concat(" :" + paramName + " ");
                }
            }
        }
        return new PersistenceBoolExpr(pqlWhere, vars.toArray());
    }

    public String getJpqlSelectExpression() {
        return this.jpqlSelectExpression;
    }

    public void setJpqlSelectExpression(String jpaSelectExpression) {
        this.jpqlSelectExpression = jpaSelectExpression;
    }

    public static void main(String[] args) {
        String t = "J\u00e4nsch";
        System.out.println(t.toUpperCase());
        System.out.println(t.toUpperCase(Locale.ENGLISH));
    }
}

