/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps.security;

import java.util.Date;
import java.util.Map;
import java.util.UUID;

public class AccountRequest {
    private UUID uuid;
    private String login;
    private String email;
    private Date requestDate;
    private Date validUntil;
    private Map<String, String[]> parameterMap;

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public AccountRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil) {
        this(uuid, login, email, requestDate, validUntil, null);
    }

    public AccountRequest(UUID uuid, String login, String email, Date requestDate, Date validUntil, Map<String, String[]> parameterMap) {
        this.uuid = uuid;
        this.login = login;
        this.email = email;
        this.requestDate = requestDate;
        this.validUntil = validUntil;
        this.parameterMap = parameterMap;
    }

    public int hashCode() {
        return this.login.hashCode() * this.uuid.hashCode();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof AccountRequest) {
            AccountRequest prr = (AccountRequest)o;
            return prr.getLogin().equals(this.login) && prr.getUuid().equals(this.uuid);
        }
        return false;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getLogin() {
        return this.login;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getRequestDate() {
        return this.requestDate;
    }

    public Date getValidUntil() {
        return this.validUntil;
    }

    public boolean isValid() {
        Date now = new Date();
        return now.before(this.validUntil);
    }
}

