/*
 * Decompiled with CFR 0.152.
 */
package ipsk.persistence;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ipsk.text.ParserException;
import java.beans.IntrospectionException;
import java.util.HashMap;
import java.util.Map;

public class PersistenceObjectIdentifier {
    public static final String KEY_TARGET_CLASS = "_oi_target_class";
    public static final String KEY_ID = "_oi_id";
    private final Object idObject;
    private final Class<?> targetClass;

    public PersistenceObjectIdentifier(Class<?> targetClass, Object idObject) {
        this.targetClass = targetClass;
        this.idObject = idObject;
    }

    public Object getIdObject() {
        return this.idObject;
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public String toString() {
        return "ID: " + this.getIdObject();
    }

    public Map<String, String[]> toQueryMap() {
        HashMap<String, String[]> queryMap = new HashMap<String, String[]>();
        queryMap.put(KEY_TARGET_CLASS, new String[]{this.targetClass.getName()});
        queryMap.put(KEY_ID, new String[]{this.idObject.toString()});
        return queryMap;
    }

    public static PersistenceObjectIdentifier parseQueryMap(Map<String, String[]> queryMap) throws ParserException, IntrospectionException {
        String[] targetClassArr = queryMap.get(KEY_TARGET_CLASS);
        if (targetClassArr != null) {
            Object idObj;
            Class<?> targetClass;
            if (targetClassArr.length != 1) {
                throw new ParserException("Ambigous keys: _oi_target_class");
            }
            String targetClassName = targetClassArr[0];
            try {
                targetClass = Class.forName(targetClassName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new IntrospectionException("Class not found: " + targetClassName);
            }
            String[] idArr = queryMap.get(KEY_ID);
            if (idArr == null) {
                throw new ParserException("Missing key: _oi_id");
            }
            if (idArr.length != 1) {
                throw new ParserException("Ambigous keys: _oi_id");
            }
            String idStr = idArr[0];
            ExtBeanInfo beanInfo = PersistenceIntrospector.getPersistenceBeanInfo(targetClass, true);
            try {
                idObj = beanInfo.createIdValueByString(idStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new IntrospectionException("Could not get ID object for class " + targetClassName + " for ID string " + idStr);
            }
            return new PersistenceObjectIdentifier(targetClass, idObj);
        }
        return null;
    }
}

