/*
 * Decompiled with CFR 0.152.
 */
package ipsk.net;

import ipsk.net.ParserException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryCollectionParser {
    public static final String NAME_INDEX_SEPARATOR = "_";
    private String paramBaseName;
    private String paramListPatternString;
    private String paramMapPatternString;
    private Pattern paramListPattern;
    private Pattern paramMapPattern;

    public QueryCollectionParser(String paramBaseName) {
        this.paramBaseName = paramBaseName;
        this.paramListPatternString = paramBaseName + "_(?<index>\\d+)";
        this.paramListPattern = Pattern.compile(this.paramListPatternString);
        this.paramMapPatternString = paramBaseName + "_(?<index>\\w+)";
        this.paramMapPattern = Pattern.compile(this.paramMapPatternString);
    }

    public Map<Integer, String[]> parseListMultiple(Map<String, String[]> paramMap) throws ParserException {
        HashMap<Integer, String[]> listMap = new HashMap<Integer, String[]>();
        for (String pn : paramMap.keySet()) {
            Matcher m = this.paramListPattern.matcher(pn);
            if (!m.matches()) continue;
            String indexGroup = m.group("index");
            try {
                int paramIndex = Integer.parseInt(indexGroup);
                listMap.put(paramIndex, paramMap.get(pn));
            }
            catch (NumberFormatException nfe) {
                throw new ParserException(nfe);
            }
        }
        return listMap;
    }

    public Map<Integer, String> parseList(Map<String, String[]> paramMap) throws ParserException {
        HashMap<Integer, String> listMap = new HashMap<Integer, String>();
        for (String pn : paramMap.keySet()) {
            Matcher m = this.paramListPattern.matcher(pn);
            if (!m.matches()) continue;
            String indexGroup = m.group("index");
            try {
                int paramIndex = Integer.parseInt(indexGroup);
                String paramValue = null;
                String[] paramValues = paramMap.get(pn);
                if (paramValues != null) {
                    int prmValsLen = paramValues.length;
                    if (prmValsLen == 1) {
                        paramValue = paramValues[0];
                    } else if (prmValsLen > 1) {
                        throw new ParserException("Multiple values for parameter " + this.paramBaseName + " with index " + paramIndex);
                    }
                }
                listMap.put(paramIndex, paramValue);
            }
            catch (NumberFormatException nfe) {
                throw new ParserException(nfe);
            }
        }
        return listMap;
    }

    public Map<String, String> parseMap(Map<String, String[]> paramMap) throws ParserException {
        HashMap<String, String> map = new HashMap<String, String>();
        for (String pn : paramMap.keySet()) {
            Matcher m = this.paramMapPattern.matcher(pn);
            if (!m.matches()) continue;
            String paramKey = m.group("index");
            try {
                String paramValue = null;
                String[] paramValues = paramMap.get(pn);
                if (paramValues != null) {
                    int prmValsLen = paramValues.length;
                    if (prmValsLen == 1) {
                        paramValue = paramValues[0];
                    } else if (prmValsLen > 1) {
                        throw new ParserException("Multiple values for parameter " + this.paramBaseName + " with key " + paramKey);
                    }
                }
                map.put(paramKey, paramValue);
            }
            catch (NumberFormatException nfe) {
                throw new ParserException(nfe);
            }
        }
        return map;
    }

    public static void main(String[] args) {
        HashMap<String, String[]> testMap = new HashMap<String, String[]>();
        testMap.put("_pg_switch_00000567", new String[]{"Bla"});
        testMap.put("_pg_switch_2", new String[]{"Foo"});
        testMap.put("_other", new String[]{"Other"});
        testMap.put("_pg_switch_2ab", new String[]{"Foo"});
        QueryCollectionParser qap = new QueryCollectionParser("_pg_switch");
        try {
            Map<Integer, String> lst = qap.parseList(testMap);
            System.out.println("list size: " + lst.size() + " " + lst.get(567) + " " + lst.get(2));
        }
        catch (ParserException e) {
            e.printStackTrace();
        }
    }
}

