/*
 * Decompiled with CFR 0.152.
 */
package ipsk.persistence;

import ipsk.math.bool.BoolExpr;
import ipsk.math.bool.ExtBoolExpr;
import ipsk.persistence.PersistenceObjectIdentifier;
import java.util.Date;
import java.util.Locale;
import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Path;

public class PersistenceCriteriaBoolExprConverter<T> {
    private CriteriaBuilder cb;
    private BoolExpr boolExpr;
    private Path<T> path;

    public PersistenceCriteriaBoolExprConverter(CriteriaBuilder cb, Path<T> path, BoolExpr boolExpr) {
        this.cb = cb;
        this.path = path;
        this.boolExpr = boolExpr;
    }

    public Expression<Boolean> createQueryData() {
        return this.createQueryData(null, this.boolExpr);
    }

    public Expression<Boolean> createQueryData(EntityManager em) {
        return this.createQueryData(em, this.boolExpr);
    }

    private Expression<Boolean> createQueryData(EntityManager em, BoolExpr e) {
        ExtBoolExpr ee;
        Path exp = null;
        Path ps = null;
        Path intExp = null;
        Path dateExp = null;
        Integer intParam = null;
        Date dateParam = null;
        Object operand0 = e.getOperand0();
        boolean caseInSensitive = false;
        if (e instanceof ExtBoolExpr && (ee = (ExtBoolExpr)e).isCaseInSensitive()) {
            caseInSensitive = true;
        }
        if (operand0 != null) {
            if (operand0 instanceof BoolExpr) {
                Path tPqd;
                exp = tPqd = this.createQueryData(em, (BoolExpr)operand0);
            } else if (operand0 instanceof String) {
                String operand0Str = (String)operand0;
                if (caseInSensitive) {
                    // empty if block
                }
                exp = this.path.get(operand0Str);
                ps = this.path.get(operand0Str);
                intExp = this.path.get(operand0Str);
                dateExp = this.path.get(operand0Str);
            }
            Object operator = e.getOperator();
            if (operator != null) {
                Object operand1 = e.getOperand1();
                Object param = null;
                if (operand1 instanceof PersistenceObjectIdentifier) {
                    PersistenceObjectIdentifier poi = (PersistenceObjectIdentifier)operand1;
                    param = em.find(poi.getTargetClass(), poi.getIdObject());
                } else {
                    param = operand1;
                }
                Object paramName = null;
                if (param != null) {
                    if (param instanceof String && caseInSensitive) {
                        param = ((String)param).toLowerCase(Locale.ENGLISH);
                    }
                    if (param instanceof Integer) {
                        intParam = (Integer)param;
                    }
                    if (param instanceof Date) {
                        dateParam = (Date)param;
                    }
                }
                if (operator.equals(ExtBoolExpr.EQUAL_KEY)) {
                    exp = this.cb.equal((Expression)exp, param);
                } else if (operator.equals(ExtBoolExpr.NOT_EQUAL_KEY)) {
                    exp = this.cb.notEqual((Expression)exp, param);
                } else if (operator.equals(ExtBoolExpr.EQUAL)) {
                    exp = intExp != null && intParam != null ? this.cb.equal((Expression)intExp, (Object)intParam) : (dateExp != null && dateParam != null ? this.cb.equal((Expression)dateExp, (Object)dateParam) : this.cb.equal((Expression)exp, param));
                } else if (operator.equals(ExtBoolExpr.NOT_EQUAL)) {
                    exp = intExp != null && intParam != null ? this.cb.notEqual((Expression)intExp, (Object)intParam) : (dateExp != null && dateParam != null ? this.cb.notEqual((Expression)dateExp, (Object)dateParam) : this.cb.notEqual((Expression)exp, param));
                } else if (operator.equals(">")) {
                    if (intExp != null && intParam != null) {
                        exp = this.cb.greaterThan((Expression)intExp, (Comparable)intParam);
                    } else if (dateExp != null && dateParam != null) {
                        exp = this.cb.greaterThan((Expression)dateExp, (Comparable)dateParam);
                    }
                } else if (operator.equals("<")) {
                    if (intExp != null && intParam != null) {
                        exp = this.cb.lessThan((Expression)intExp, (Comparable)intParam);
                    } else if (dateExp != null && dateParam != null) {
                        exp = this.cb.lessThan((Expression)dateExp, (Comparable)dateParam);
                    }
                } else if (operator.equals("(starts with)")) {
                    String likePattern = param + "%";
                    exp = this.cb.like((Expression)ps, likePattern);
                } else if (operator.equals("(ends with)")) {
                    String likePattern = "%" + param;
                    exp = this.cb.like((Expression)ps, likePattern);
                } else if (operator.equals(ExtBoolExpr.CONTAINS)) {
                    String likePattern = "%" + param + "%";
                    exp = this.cb.like((Expression)ps, likePattern);
                } else {
                    if (operator.equals(ExtBoolExpr.MEMBER)) {
                        throw new IllegalArgumentException("Operator " + ExtBoolExpr.MEMBER + " not implemented yet.");
                    }
                    if (operator.equals(ExtBoolExpr.EQUALS)) {
                        exp = this.cb.equal((Expression)exp, param);
                    } else {
                        if (operator.equals(ExtBoolExpr.NOT_MEMBER)) {
                            throw new IllegalArgumentException("Operator " + ExtBoolExpr.NOT_MEMBER + " not implemented yet.");
                        }
                        if (operator.equals(ExtBoolExpr.EQUALS_NOT)) {
                            throw new IllegalArgumentException("Operator " + ExtBoolExpr.EQUALS_NOT + " not implemented yet.");
                        }
                        if (operator.equals(ExtBoolExpr.BOUND)) {
                            throw new IllegalArgumentException("Operator " + ExtBoolExpr.BOUND + " not implemented yet.");
                        }
                        if (operator.equals(ExtBoolExpr.NOT_BOUND)) {
                            throw new IllegalArgumentException("Operator " + ExtBoolExpr.NOT_BOUND + " not implemented yet.");
                        }
                        if (operator.equals(ExtBoolExpr.AND)) {
                            if (param instanceof BoolExpr) {
                                Expression<Boolean> tPqd = this.createQueryData(em, (BoolExpr)param);
                                exp = this.cb.and((Expression)exp, tPqd);
                            }
                        } else if (operator.equals(ExtBoolExpr.OR)) {
                            if (param instanceof BoolExpr) {
                                Expression<Boolean> tPqd = this.createQueryData(em, (BoolExpr)param);
                                exp = this.cb.or((Expression)exp, tPqd);
                            }
                        } else {
                            throw new IllegalArgumentException("Unkown operator \"" + operator + "\".");
                        }
                    }
                }
            }
        }
        return exp;
    }
}

