/*
 * Decompiled with CFR 0.152.
 */
package ipsk.webapps;

import ips.servlet.http.URLEncoder;
import ipsk.text.StringTokenizer;
import ipsk.webapps.ControllerException;
import ipsk.webapps.HttpRequestParameterMapWrapper;
import ipsk.webapps.ProcessResult;
import ipsk.webapps.actionmap.ActionLink;
import ipsk.webapps.actionmap.ActionMap;
import ipsk.webapps.actionmap.Controller;
import ipsk.webapps.actionmap.Forward;
import ipsk.webapps.actionmap.Param;
import java.beans.Beans;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.bind.DataBindingException;
import javax.xml.bind.JAXB;

public class ControllerDispatcherServlet
extends HttpServlet
implements ServletContainerInitializer {
    public static final boolean DEBUG = false;
    public static final String SERVLET_NAME = "ActionDispatcher";
    public static final String DEFAULT_MAP_NAME = "/WEB-INF/classes/META-INF/ips_webutils_action_map.xml";
    public static final String DYNAMIC_SERVLET_MAPPING_PARAM_NAME = "dynamic_servlet_mapping";
    private HashMap<String, ActionLink> map = new HashMap();

    private ForwardRequest checkForwardRequest(ipsk.jsp.Controller ctrl, Forward fw, HttpServletRequest httpReq) throws ServletException {
        int paramsCount;
        ForwardRequest forwardRequest = null;
        String forwardPath = null;
        HttpRequestParameterMapWrapper modifiedRequest = null;
        String onSuccessUrl = fw.getUrl();
        List<Param> params = fw.getParams();
        HashMap<String, String[]> newParamMap = new HashMap<String, String[]>();
        if (params != null && (paramsCount = params.size()) > 0) {
            onSuccessUrl = onSuccessUrl.concat("?");
            for (int i = 0; i < paramsCount; ++i) {
                Param p = params.get(i);
                String name = p.getName();
                String value = p.getValue();
                if (value == null) {
                    String ctrlVal = p.getControllerValue();
                    String[] valPnames = StringTokenizer.split((String)ctrlVal, (char)'.');
                    Object pVal = "";
                    if (valPnames.length > 0) {
                        pVal = ctrl;
                        for (String valPname : valPnames) {
                            StringBuffer getterNameSb = new StringBuffer("get");
                            String firstCharUpper = valPname.substring(0, 1).toUpperCase();
                            getterNameSb.append(firstCharUpper);
                            getterNameSb.append(valPname.substring(1));
                            String getterName = getterNameSb.toString();
                            if (pVal == null) {
                                throw new ServletException("Error resolving values. Try to call method " + getterName + " on a null value.");
                            }
                            Class<?> pValClass = pVal.getClass();
                            try {
                                Object newPVal;
                                Method getterMethod = pValClass.getMethod(getterName, new Class[0]);
                                pVal = newPVal = getterMethod.invoke(pVal, new Object[0]);
                            }
                            catch (Exception e) {
                                throw new ServletException("Error resolving values. Could not find method " + getterName + " in class " + pValClass.getName(), (Throwable)e);
                            }
                        }
                    }
                    if (pVal != null) {
                        value = pVal.toString();
                    }
                }
                if (value == null) continue;
                newParamMap.put(name, new String[]{value});
            }
        }
        if (onSuccessUrl != null && !"".equals(onSuccessUrl)) {
            forwardPath = onSuccessUrl;
            modifiedRequest = new HttpRequestParameterMapWrapper(httpReq, newParamMap);
        }
        if (forwardPath != null) {
            forwardRequest = new ForwardRequest(forwardPath, fw.getRedirect(), (HttpServletRequest)modifiedRequest);
        }
        return forwardRequest;
    }

    public void service(HttpServletRequest httpReq, HttpServletResponse res) throws ServletException, IOException {
        String servletPath;
        String pathInfo = httpReq.getPathInfo();
        if (pathInfo != null) {
            // empty if block
        }
        if ((servletPath = httpReq.getServletPath()) != null) {
            String ctrlClassName;
            ActionLink al = this.map.get(servletPath);
            if (al == null) {
                throw new ServletException("Action link for path " + servletPath + " not found!");
            }
            Controller ct = al.getController();
            if (ct != null && (ctrlClassName = ct.getClassname()) != null) {
                Controller.Scope ctScope;
                Object ctrlO = null;
                HttpSession httpSession = null;
                String ctVar = ct.getVar();
                if (ctVar != null) {
                    ctScope = ct.getScope();
                    if (ctScope.equals((Object)Controller.Scope.SESSION)) {
                        httpSession = httpReq.getSession(true);
                        if (httpSession != null) {
                            ctrlO = httpSession.getAttribute(ctVar);
                        }
                    } else if (ctScope.equals((Object)Controller.Scope.REQUEST)) {
                        ctrlO = httpReq.getAttribute(ctVar);
                    } else if (ctScope.equals((Object)Controller.Scope.APPLICATION)) {
                        ctrlO = this.getServletContext().getAttribute(ctVar);
                    }
                }
                if (ctrlO == null) {
                    try {
                        ctrlO = Beans.instantiate(((Object)((Object)this)).getClass().getClassLoader(), ctrlClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new ServletException((Throwable)e);
                    }
                    if (ctVar != null) {
                        ctScope = ct.getScope();
                        if (ctScope.equals((Object)Controller.Scope.SESSION)) {
                            if (httpSession != null) {
                                httpSession.setAttribute(ctVar, ctrlO);
                            }
                        } else if (ctScope.equals((Object)Controller.Scope.REQUEST)) {
                            httpReq.setAttribute(ctVar, ctrlO);
                        } else if (ctScope.equals((Object)Controller.Scope.APPLICATION)) {
                            this.getServletContext().setAttribute(ctVar, ctrlO);
                        }
                    }
                }
                if (ctrlO instanceof ipsk.jsp.Controller) {
                    String processMethodName;
                    ProcessResult pr = null;
                    ipsk.jsp.Controller ctrl = (ipsk.jsp.Controller)ctrlO;
                    ipsk.persistence.Controller pctrl = null;
                    if (ctrlO instanceof ipsk.persistence.Controller) {
                        pctrl = (ipsk.persistence.Controller)ctrlO;
                    }
                    if (pctrl != null) {
                        pctrl.open();
                    }
                    if ((processMethodName = ct.getProcessMethod()) == null) {
                        try {
                            pr = ctrl.process(httpReq, res, (Servlet)this);
                        }
                        catch (ControllerException e) {
                            if (pctrl != null) {
                                pctrl.rollback();
                            }
                            e.printStackTrace();
                            throw new ServletException((Throwable)e);
                        }
                    }
                    Class<?> ctrlCls = ctrl.getClass();
                    try {
                        Method processMethod = ctrlCls.getMethod(processMethodName, HttpServletRequest.class);
                        processMethod.invoke((Object)ctrl, httpReq);
                        pr = ctrl.getProcessResult();
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                        if (pctrl != null) {
                            pctrl.rollback();
                        }
                        e.printStackTrace();
                        throw new ServletException((Throwable)e);
                    }
                    Object forwardPath = servletPath + ".jsp";
                    ForwardRequest forwardRequest = null;
                    try {
                        if (pr != null) {
                            if (ProcessResult.Type.DONE.equals((Object)pr.getType())) {
                                forwardPath = null;
                            } else {
                                List<Forward> fws = al.getForwards();
                                if (fws != null && fws.size() > 0) {
                                    String fwst;
                                    for (Forward fw : fws) {
                                        fwst = fw.getStatus();
                                        if (!pr.getType().toString().equalsIgnoreCase(fwst)) continue;
                                        forwardRequest = this.checkForwardRequest(ctrl, fw, httpReq);
                                        break;
                                    }
                                    if (forwardRequest == null) {
                                        for (Forward fw : fws) {
                                            fwst = fw.getStatus();
                                            if (fwst != null) continue;
                                            forwardRequest = this.checkForwardRequest(ctrl, fw, httpReq);
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        if (pctrl != null) {
                            pctrl.close();
                        }
                        boolean redirect = false;
                        if (forwardRequest != null) {
                            forwardPath = forwardRequest.getForwardPath();
                            redirect = forwardRequest.getRedirect();
                        }
                        if (forwardPath != null) {
                            HttpServletRequest modifiedRequest = null;
                            if (forwardRequest != null) {
                                modifiedRequest = forwardRequest.getRequest();
                            }
                            RequestDispatcher requestDispatcher = httpReq.getRequestDispatcher((String)forwardPath);
                            if (redirect) {
                                Map pMap = modifiedRequest != null ? modifiedRequest.getParameterMap() : httpReq.getParameterMap();
                                String qStr = URLEncoder.parameterMapToQueryString(pMap);
                                String redirectLoc = httpReq.getContextPath() + (String)forwardPath + qStr;
                                String encRedirectURL = res.encodeRedirectURL(redirectLoc);
                                res.setStatus(303);
                                res.setHeader("Location", encRedirectURL);
                            } else if (modifiedRequest != null) {
                                requestDispatcher.forward((ServletRequest)modifiedRequest, (ServletResponse)res);
                            } else {
                                requestDispatcher.forward((ServletRequest)httpReq, (ServletResponse)res);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new ServletException((Throwable)e);
                    }
                }
            }
        }
    }

    public void init() throws ServletException {
        ServletContext ctx = this.getServletContext();
        InputStream is = ctx.getResourceAsStream(DEFAULT_MAP_NAME);
        if (is != null) {
            InputStreamReader mr = new InputStreamReader(is);
            try {
                ActionMap actionMap = (ActionMap)JAXB.unmarshal((Reader)mr, ActionMap.class);
                ActionLink[] als = actionMap.getActionLink();
                if (als != null) {
                    for (ActionLink al : als) {
                        String alUrl = al.getUrl();
                        this.map.put(alUrl, al);
                    }
                }
            }
            catch (DataBindingException dbe) {
                this.log(dbe.getMessage(), dbe);
                dbe.printStackTrace();
                throw new ServletException(dbe.getMessage(), (Throwable)dbe);
            }
        }
    }

    public void onStartup(Set<Class<?>> c, ServletContext ctx) throws ServletException {
        InputStream is = ctx.getResourceAsStream(DEFAULT_MAP_NAME);
        if (is == null) {
            ctx.log("Note: ActionDispatcher servlet: Action map /WEB-INF/classes/META-INF/ips_webutils_action_map.xml not found. Servlet will not be registered.");
        } else {
            ctx.log("Registering ActionDispatcher servlet dynamically...");
            InputStreamReader mr = new InputStreamReader(is);
            ArrayList<String> mappingUrls = new ArrayList<String>();
            try {
                ActionMap actionMap = (ActionMap)JAXB.unmarshal((Reader)mr, ActionMap.class);
                ActionLink[] als = actionMap.getActionLink();
                if (als != null) {
                    for (ActionLink al : als) {
                        String alUrl = al.getUrl();
                        mappingUrls.add(alUrl);
                    }
                }
            }
            catch (DataBindingException dbe) {
                this.log(dbe.getMessage(), dbe);
                dbe.printStackTrace();
                throw new ServletException(dbe.getMessage(), (Throwable)dbe);
            }
            ServletRegistration.Dynamic dynReg = ctx.addServlet(SERVLET_NAME, ((Object)((Object)this)).getClass());
            if (dynReg == null) {
                ctx.log("ActionDispatcher already registered!");
            } else {
                dynReg.addMapping(mappingUrls.toArray(new String[mappingUrls.size()]));
                ctx.log("Registered Servlet ActionDispatcher (class: " + ((Object)((Object)this)).getClass() + ") with " + mappingUrls.size() + " mappings.");
            }
        }
    }

    public static class ForwardRequest {
        private String forwardPath;
        private boolean redirect;
        private HttpServletRequest request;

        public ForwardRequest(String forwardPath, boolean redirect, HttpServletRequest request) {
            this.forwardPath = forwardPath;
            this.redirect = redirect;
            this.request = request;
        }

        public String getForwardPath() {
            return this.forwardPath;
        }

        public boolean getRedirect() {
            return this.redirect;
        }

        public HttpServletRequest getRequest() {
            return this.request;
        }
    }
}

