import {AfterViewInit, Component} from "@angular/core";
import {Script, ScriptService} from "speechrecorderng";
import {ActivatedRoute, Params, Router} from "@angular/router";

@Component({
    selector: 'wsp-scripteditor',
    template: `
        <h1>Script</h1>
      
        <p>Sections:</p>
        <ul>
            <li *ngFor="let section of script?.sections">
                Section
            </li>
        </ul>
  `,
    styles: [],
    standalone: false
})
export class ScriptEditor implements AfterViewInit{
    script:Script|null;

    constructor(private route: ActivatedRoute,
                private router: Router,
                private scriptService: ScriptService) {
    }

    ngAfterViewInit(){
                this.route.queryParams.subscribe((params: Params) => {
                    if (params['scriptId']) {
                        this.fetchScript(params['scriptId']);
                    }
                });

                this.route.params.subscribe((params: Params) => {
                    let routeParamsId = params['id'];
                    if (routeParamsId) {
                        this.fetchScript(routeParamsId);
                    }
                })
            }

    fetchScript(scriptId:string){
        let scPms= this.scriptService.scriptObservable(scriptId)

        if(scPms) {
            scPms.subscribe(sc => {
                this.script=sc;
            },reason => {
                   // TODO
                    console.log("Error fetching session " + reason)
                });
        }
    }
}
