
#include <windows.h>
#include <stdio.h>
#include <string.h>
#include <jni.h>

#include <dsound.h>
#include "ips_audio_ds_DSSourceDataLine.h"

jlong lastFramePosition;

LPDSSDL getNativeSourceDataLine(JNIEnv *env,jobject obj){
	return (LPDSSDL) getNativeDataLine(env,obj);
}

JNIEXPORT jbyteArray JNICALL Java_ips_audio_ds_DSSourceDataLine_open(JNIEnv* env, jobject obj,jbyteArray jDevGuid,jfloat samplesPerSec,jint bitsPerSample,jint frameSize,jint channels,jint bufferSize){
	//jboolean isCopy;
	//LPDIRECTSOUND *pDevP=(LPDIRECTSOUND *)env->GetByteArrayElements(np,&isCopy);
	//LPDIRECTSOUND pDev=(*pDevP);
	lastFramePosition=0;
	LPUNKNOWN pUnkOuter=0;
	LPDSSDL lpsdl=new DSDataLine();
	memset(lpsdl,0,sizeof(DSDataLine));
	LPGUID devLpGuid=NULL;
	jboolean isCopy;
	if(jDevGuid != NULL){
		devLpGuid=(LPGUID)env->GetByteArrayElements(jDevGuid,&isCopy);
	}
	HRESULT	hr= DirectSoundCreate(devLpGuid, &(lpsdl->dsDev), NULL);
		if(hr!=DS_OK){
			delete lpsdl;
	if(hr==DSERR_INVALIDPARAM){
				env->ThrowNew(env->FindClass("java/lang/IllegalArgumentException"),"Invalid parameter with native DirectSound method call");
			}else if(hr==DSERR_OUTOFMEMORY){
				env->ThrowNew(env->FindClass("java/lang/OutOfMemoryError"),"DirectSound: Out of memory");
			}else{
				env->ThrowNew(env->FindClass("ips/audio/ds/DSException"),dsErrToString(hr));
			}
			
			return NULL;
		}

			
			HWND mWindow = GetForegroundWindow();
			if (mWindow == NULL) {
				mWindow = GetDesktopWindow();
			}
			if(lpsdl->dsDev->SetCooperativeLevel(mWindow, DSSCL_PRIORITY)!=DS_OK){
				lpsdl->dsDev->Release();
				delete lpsdl;
				env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Could not set priority cooperative level.");
				return NULL;
			}
		
	//WAVEFORMATEX format;

	//WORD blockAlign=(WORD)((bitsPerSample * channels) / 8); 
	WORD blockAlign=(WORD)frameSize;
	/*lpsdl->formatExt.Format.wFormatTag=WAVE_FORMAT_PCM; 
	lpsdl->formatExt.Format.nChannels=(WORD)channels; 
	lpsdl->formatExt.Format.nSamplesPerSec=(DWORD)samplesPerSec; 
	lpsdl->formatExt.Format.nAvgBytesPerSec=((DWORD)samplesPerSec)*blockAlign; 
	lpsdl->formatExt.Format.nBlockAlign=blockAlign; 
	lpsdl->formatExt.Format.wBitsPerSample=(WORD)bitsPerSample; 
	lpsdl->formatExt.Format.cbSize=0; */

	lpsdl->formatExt.Format.wFormatTag=WAVE_FORMAT_EXTENSIBLE;
	lpsdl->formatExt.Format.nChannels=(WORD)channels; 
	lpsdl->formatExt.Format.nSamplesPerSec=(DWORD)samplesPerSec; 
	lpsdl->formatExt.Format.nAvgBytesPerSec=(DWORD)samplesPerSec*blockAlign; 
	lpsdl->formatExt.Format.nBlockAlign=blockAlign; 
	// DS docs: "container size" 
	//lptdl->formatExt.Format.wBitsPerSample=(WORD)bitsPerSample; 
	lpsdl->formatExt.Format.wBitsPerSample=(WORD)(frameSize/channels)*8;
	//lptdl->formatExt.Format.cbSize=sizeof(WAVEFORMATEXTENSIBLE)-sizeof(WAVEFORMATEX);
	lpsdl->formatExt.Format.cbSize=22;
	lpsdl->formatExt.Samples.wValidBitsPerSample=(WORD)bitsPerSample;
	//lptdl->formatExt.dwChannelMask=0xFFFFFFFF;
	lpsdl->formatExt.dwChannelMask=0;
	lpsdl->formatExt.SubFormat=KSDATAFORMAT_SUBTYPE_PCM;

	/*printf("SDL chs: %d\n", lpsdl->formatExt.Format.nChannels);
	printf("SDL sr: %d\n",lpsdl->formatExt.Format.nSamplesPerSec);
	printf("SDL blockAlign: %d\n", lpsdl->formatExt.Format.nBlockAlign);
	printf("SDL bitsPerSample: %d\n", lpsdl->formatExt.Format.wBitsPerSample);
	fflush(stdout);*/

	lpsdl->bufDesc.dwSize=sizeof(DSBUFFERDESC);
	lpsdl->bufDesc.dwFlags=DSBCAPS_GETCURRENTPOSITION2 | DSBCAPS_GLOBALFOCUS;
	lpsdl->bufDesc.dwBufferBytes=bufferSize;
	lpsdl->bufDesc.dwReserved=0;
	lpsdl->bufDesc.lpwfxFormat=&(lpsdl->formatExt.Format);
	lpsdl->bufDesc.guid3DAlgorithm=GUID_NULL;

	lpsdl->writePosition=0;
	lpsdl->lpdscb=NULL;
	lpsdl->active=false;
	lpsdl->running=false;
	
	//HWND mWindow = GetForegroundWindow();
	//if (mWindow == NULL) {
	//	mWindow = GetDesktopWindow();
	//}
	//if(pDev->SetCooperativeLevel(mWindow, DSSCL_PRIORITY)!=DS_OK){
	//	env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Could not set priority cooperative level.");
	//	return NULL;
	//}

	LPUNKNOWN sbCreatepUnk=NULL;
	hr=lpsdl->dsDev->CreateSoundBuffer(&(lpsdl->bufDesc),(LPDIRECTSOUNDBUFFER *)&(lpsdl->lpdsb),sbCreatepUnk);
	if(hr!=DS_OK){
		//const char *baseMsg="Could not create DirectSound playback buffer: ";
		char *dsErrMsg=dsErrToString(hr);
		//char *msg=(char *)calloc(strlen(baseMsg)+strlen(dsErrMsg)+1,sizeof(char));
		//strncpy_s(msg,strlen(baseMsg)+strlen(dsErrMsg),baseMsg,strlen(baseMsg));
		//strncat_s(msg,strlen(baseMsg)+strlen(dsErrMsg),dsErrMsg,strlen(dsErrMsg));
		lpsdl->dsDev->Release();
		delete lpsdl;
		env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),dsErrMsg);
		return NULL;
	}
	////lpsdl->lpdsb->SetFormat(&(lpsdl->format));
	//HWND mWindow = GetForegroundWindow();
	//if (mWindow == NULL) {
	//	mWindow = GetDesktopWindow();
	//}
	//if(pDev->SetCooperativeLevel(mWindow, DSSCL_PRIORITY)!=DS_OK){
	//	env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Could not set priority cooperative level.");
	//	return NULL;
	//}
	jbyteArray sdlArr=env->NewByteArray(sizeof(LPDSSDL));
	env->SetByteArrayRegion(sdlArr,0,sizeof(LPDSSDL),(jbyte *)(&lpsdl));
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
	printf("SDL opened with buffer size: %d (%lu)\n",bufferSize,lpsdl->bufDesc.dwBufferBytes);
	fflush(stdout);
#endif
	return sdlArr;
}

JNIEXPORT jint JNICALL Java_ips_audio_ds_DSSourceDataLine_available(JNIEnv *env, jobject obj){
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	jint avail=0;
	DWORD dsPlayPosition;
	DWORD dsWritePosition;
	if(lpsdl !=NULL && lpsdl->lpdsb!=NULL){
		HRESULT hr=lpsdl->lpdsb->GetCurrentPosition(&dsPlayPosition,&dsWritePosition);
		if(hr==DS_OK){
			int unAvail=dsWritePosition-dsPlayPosition;
			if(unAvail<0)unAvail+=lpsdl->bufDesc.dwBufferBytes;
			avail=lpsdl->bufDesc.dwBufferBytes-unAvail;
		}
	}
	return avail;
}

JNIEXPORT jlong JNICALL Java_ips_audio_ds_DSSourceDataLine_getLongFramePosition(JNIEnv* env, jobject obj){
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	jlong playPosFrames=0;
	if(lpsdl!=NULL && lpsdl->lpdsb!=NULL){
		DWORD dsPlayPosition;
		jlong writePos=lpsdl->writePosition;
		HRESULT hr=lpsdl->lpdsb->GetCurrentPosition(&dsPlayPosition,NULL); 
		if(hr==DS_OK){
			jlong writeBufPos=writePos % lpsdl->bufDesc.dwBufferBytes;
			jlong buffered=writeBufPos-dsPlayPosition;
			//if(lpsdl->running && buffered<=0){
			if(buffered<0){
				buffered+=lpsdl->bufDesc.dwBufferBytes;
				//printf("getLongFramePosition buffered %d\n",buffered);
				//fflush(stdout);
			}
			//printf("framePos %d\n",writePos/lpsdl->formatExt.Format.nBlockAlign);
			//printf("buffered %d\n",buffered/lpsdl->formatExt.Format.nBlockAlign);
			//fflush(stdout);
			jlong playPosBytes=writePos-buffered;
			playPosFrames=playPosBytes/lpsdl->formatExt.Format.nBlockAlign;
		}
	}
	//printf("framePosition %d\n",playPosFrames);
	
	//fflush(stdout);
	return playPosFrames;
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSSourceDataLine_flush(JNIEnv* env, jobject obj){
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	if(lpsdl!=NULL && lpsdl->lpdsb!=NULL){
		DWORD writePosBuf=(DWORD)(lpsdl->writePosition % lpsdl->bufDesc.dwBufferBytes);
	/*	DWORD dsPlayPosition;
		HRESULT hr=lpsdl->lpdsb->GetCurrentPosition(&dsPlayPosition,NULL); 
		if(hr==DS_OK){
		HRESULT hr=lpsdl->lpdsb->SetCurrentPosition(writePosBuf);
		if(hr==DS_OK){
			jlong flushed=writePosBuf-dsPlayPosition;
			if(flushed<0)flushed+=lpsdl->bufDesc.dwBufferBytes;
			lpsdl->writePosition-=flushed;
		}
		}*/

	lpsdl->writePosition-=writePosBuf;
	HRESULT hr=lpsdl->lpdsb->SetCurrentPosition(0);
		if(hr!=DS_OK){
			// TODO
		}

	}
}

void play(LPDSSDL lpsdl){
	// start playback if active, not running and data available
	if(lpsdl!=NULL && lpsdl->lpdsb!=NULL && lpsdl->active){
		jlong writePos=lpsdl->writePosition;
		DWORD dsPlayPosition;
		HRESULT hr=lpsdl->lpdsb->GetCurrentPosition(&dsPlayPosition,NULL); 
		if(hr==DS_OK){
			jlong writeBufPos=writePos % lpsdl->bufDesc.dwBufferBytes;
			jlong buffered=writeBufPos-dsPlayPosition;
			if(buffered!=0){
				DWORD status;
				hr=lpsdl->lpdsb->GetStatus(&status);
				if(hr==DS_OK && (status & DSBSTATUS_LOOPING)){
					// already loop playing
					return;
				}
				HRESULT hr=lpsdl->lpdsb->Play(0,0,DSBPLAY_LOOPING);
				if(hr!=DS_OK){
					fprintf(stderr,"Error start playback!\n");
					fflush(stderr);
				}else{
					lpsdl->running=true;
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
		printf("SDL: started by start\n");
		fflush(stdout);
#endif
				}
			}
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
			else{
				printf("no data available - not started\n");
				fflush(stdout);
			}
#endif
		}
	}

}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSSourceDataLine_nStart(JNIEnv *env, jobject obj){
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	if(lpsdl!=NULL && lpsdl->lpdsb!=NULL){
		// if we start here the empty buffer is played !!
		//lpsdl->lpdsb->Play(0,0,DSBPLAY_LOOPING);
		if(!lpsdl->active){
			lpsdl->active=true;
			play(lpsdl);
		}

	}
}

JNIEXPORT jint JNICALL Java_ips_audio_ds_DSSourceDataLine_write(JNIEnv *env, jobject obj,jbyteArray buf,jint offset,jint len) {
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	jint written=0;
	if(lpsdl!=NULL && lpsdl->lpdsb!=NULL){
		LPVOID pvAudioPtr1;
		DWORD dwAudioBytes1=0;
		LPVOID pvAudioPtr2;
		DWORD dwAudioBytes2=0;

		if(!lpsdl->active){
			return 0;
		}

		jint avail=0;

		// wait for available

//		DWORD dsWritePosition;
		DWORD dsPlayPosition;
		DWORD writePosOffset=lpsdl->writePosition % lpsdl->bufDesc.dwBufferBytes;
		while(lpsdl->active && avail<len){
			lpsdl->lpdsb->GetCurrentPosition(&dsPlayPosition,NULL); 
			//printf("dsPlayPosition (frames): %d\n",dsPlayPosition/lpsdl->formatExt.Format.nBlockAlign);
			fflush(stdout);
			int unAvail=writePosOffset-dsPlayPosition;

			if(unAvail==0 && lpsdl->running){
				unAvail=lpsdl->bufDesc.dwBufferBytes;
			}
			if(unAvail<0){
				unAvail+=lpsdl->bufDesc.dwBufferBytes;
			}
			avail=lpsdl->bufDesc.dwBufferBytes-unAvail;
			// leave one sampleframe empty
			// otherwise it is hard to distinguish if the buffer
			// is totally full or totally empty
			avail-=lpsdl->formatExt.Format.nBlockAlign;
			if(avail<len){
				Sleep(10);
			}
		};
		//printf("SDL avail: %d\n",avail);

		if(lpsdl->active){
		//lpsdl->lpdsb->GetCurrentPosition(NULL,&dsWritePosition);
			if(!lpsdl->running &&  avail<=(jint)lpsdl->bufDesc.dwBufferBytes/2){
				HRESULT hr=lpsdl->lpdsb->Play(0,0,DSBPLAY_LOOPING);
				if(hr!=DS_OK){
					fprintf(stderr,"Error start playback!\n");
					fflush(stderr);

				}else{
					lpsdl->running=true;
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
					//printf("dsWritePosition (frames): %d\n",dsWritePosition/lpsdl->formatExt.Format.nBlockAlign);
					printf("SDL: started by write\n");
					fflush(stdout);
#endif
				}
			}
			int locksize=avail;
			if(locksize>len)locksize=len;

			HRESULT hr=lpsdl->lpdsb->Lock(writePosOffset,locksize,&pvAudioPtr1,&dwAudioBytes1,&pvAudioPtr2,&dwAudioBytes2,0);
			if(hr!=DS_OK){
				//env->ThrowNew(env->FindClass("javax/sound/sampled/IOException"),"Could not set priority cooperative level.");
				Sleep(1000);
				fprintf(stderr,"Cannot lock SDL buffer!\n");
				fflush(stderr);
				return 0;
			}
			//printf("writeBufOffset %d\n",writePosOffset);
			//printf("bytes 1 %d\n",dwAudioBytes1);
			//printf("bytes 2 %d\n",dwAudioBytes2);
			//printf("pointer 1 %x\n",pvAudioPtr1);
			if(pvAudioPtr1 != NULL && dwAudioBytes1>0){
				env->GetByteArrayRegion(buf,offset,dwAudioBytes1,(jbyte *)pvAudioPtr1);
				written+=dwAudioBytes1;

				if(pvAudioPtr2!=NULL && dwAudioBytes2>0){
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
					printf("SDL Buffer wrap %d bytes\n",dwAudioBytes2);
					fflush(stdout);
#endif
					env->GetByteArrayRegion(buf,offset+dwAudioBytes1,dwAudioBytes2,(jbyte *)pvAudioPtr2);
					written+=(dwAudioBytes2);
				}
			}
			hr=lpsdl->lpdsb->Unlock(pvAudioPtr1,dwAudioBytes1,pvAudioPtr2,dwAudioBytes2);
			if(hr!=DS_OK){
				fprintf(stderr,"SDL buffer unlock error\n");
				fflush(stderr);
			}
			lpsdl->writePosition+=written;
			//printf("Written %d\n",written);
			fflush(stdout);

			//writePosOffset+=written;
			//writePosOffset=writePosOffset % lpsdl->bufDesc.dwBufferBytes;
		}
		}
	
	//if(written != len){
	//	printf("Len %d\n",len);
	//	printf("written %d\n",written);
	//	fflush(stdout);
	//}
	return written;
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSSourceDataLine_nStop(JNIEnv *env, jobject obj){
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	if(lpsdl!=NULL){
		if(lpsdl->lpdsb!=NULL){
			if(lpsdl->active){
				lpsdl->lpdsb->Stop();
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
				printf("SDL native stopped\n");
				fflush(stdout);
#endif
			}
		}
		lpsdl->active=false;
		lpsdl->running=false;
	}
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSSourceDataLine_drain(JNIEnv *env, jobject obj){
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	if(lpsdl!=NULL && lpsdl->lpdsb!=NULL){
		jlong buffered=(lpsdl->bufDesc.dwBufferBytes)*2;
		jlong lastBuffered;
		jlong writePos=lpsdl->writePosition;
		jlong writeBufPos=writePos % lpsdl->bufDesc.dwBufferBytes;
		jlong clearBufPos=writeBufPos;
		DWORD cleared=0;
		do{
			DWORD dsPlayPosition;
			lastBuffered=buffered;
			HRESULT hr=lpsdl->lpdsb->GetCurrentPosition(&dsPlayPosition,NULL); 
			if(hr==DS_OK){
				buffered=writeBufPos-dsPlayPosition;
				//printf("SDL drain 1 buffered %d\n",buffered);
				//printf("SDL drain 1a bufsize %u\n",lpsdl->bufDesc.dwBufferBytes);
				//fflush(stdout);
				if(buffered < 0){
					buffered+=lpsdl->bufDesc.dwBufferBytes;
				}
				// for short streams we have to start the line first
				if(buffered >0 && lpsdl->active && !lpsdl->running ){
				HRESULT hr=lpsdl->lpdsb->Play(0,0,DSBPLAY_LOOPING);
				if(hr!=DS_OK){
					fprintf(stderr,"Error start playback!\n");
					fflush(stderr);

				}else{
					lpsdl->running=true;
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
					printf("SDL: started by drain \n");
					fflush(stdout);
#endif
				}
			}
				//printf("SDL drain 3 lastBuffered %d buffered %d\n",lastBuffered,buffered);
				//fflush(stdout);
				if(buffered!=0 && buffered <= lastBuffered){
					if(lpsdl->bufDesc.dwBufferBytes> (buffered + cleared)){
						LPVOID pvAudioPtr1;
						DWORD dwAudioBytes1=0;
						LPVOID pvAudioPtr2;
						DWORD dwAudioBytes2=0;
						// clear rest of buffer
						DWORD toClear=lpsdl->bufDesc.dwBufferBytes-(DWORD)(buffered + cleared);
						//printf("SDL drain 4 to clear %d\n",toClear);
						//fflush(stdout);
						HRESULT hr=lpsdl->lpdsb->Lock((DWORD)clearBufPos,toClear,&pvAudioPtr1,&dwAudioBytes1,&pvAudioPtr2,&dwAudioBytes2,0);
						if(hr!=DS_OK){
							fprintf(stderr,"SDL Error locking buffer to drain\n");
							fflush(stderr);
							return;
						}
						if((dwAudioBytes1)>0){
							memset(pvAudioPtr1,0,dwAudioBytes1);
							clearBufPos+=dwAudioBytes1;
							cleared+=dwAudioBytes1;
						}
						if(pvAudioPtr2!=NULL && dwAudioBytes2>0){
							memset(pvAudioPtr2,0,dwAudioBytes2);
							clearBufPos+=dwAudioBytes2;
							cleared+=dwAudioBytes2;
						}
						hr=lpsdl->lpdsb->Unlock(pvAudioPtr1,dwAudioBytes1,pvAudioPtr2,dwAudioBytes2);
						if(hr!=DS_OK){
							fprintf(stderr,"SDL Error unlocking buffer to drain\n");
							fflush(stderr);
							return;
						}
						clearBufPos=clearBufPos % lpsdl->bufDesc.dwBufferBytes;
					}
					Sleep(10);
				}
			}
		}while(lpsdl->active && buffered!=0 && buffered <= lastBuffered);
	/*	printf("SDL native drained:\n");
		printf("SDL active: %d\n",lpsdl->active);
		printf("SDL buffered: %d\n",buffered);
		printf("SDL lastBuffered: %d\n",lastBuffered);
		fflush(stdout);
		*/
	}
}


JNIEXPORT void JNICALL Java_ips_audio_ds_DSSourceDataLine_release(JNIEnv* env, jobject obj){
	LPDSSDL lpsdl=getNativeSourceDataLine(env,obj);
	if(lpsdl!=NULL){
		if(lpsdl->lpdsb!=NULL){
			lpsdl->lpdsb->Release();
			lpsdl->lpdsb=NULL;
		}
		if(lpsdl->dsDev!=NULL){
			lpsdl->dsDev->Release();
			lpsdl->dsDev=NULL;
		}
#ifdef ips_audio_ds_DSSourceDataLine_DEBUG
		printf("SDL buffer %x release.\n",lpsdl);
		fflush(stdout);
#endif
		delete lpsdl;
	}
}