#include "ds_common.h"


void reverseByteOrder(jbyte *srcBuf,jint offset,jint len,jint frameSize,jbyte *trgBuf){
	
	for(jint i=0;i<len;i++){
		jint srcPos=offset+(i*frameSize);
		jint trgPos=offset+(i*frameSize);
		for(jint bi=0;bi<frameSize;bi++){
			*(trgBuf+(trgPos+frameSize-1-bi))=*(srcBuf+srcPos+bi);
		}
	}
	
}


char * dsErrToString(HRESULT hr){
	switch(hr){
		case DSERR_INVALIDPARAM:
			return "invalid parameter(s)";
		case DSERR_NOAGGREGATION:
			return "no aggregation";
		case DSERR_OUTOFMEMORY:
			return "out of memory error";
		case DSERR_ALLOCATED:
			return "already allocated";
		case DSERR_BADFORMAT:
			return "bad audio format";
		case DSERR_BUFFERTOOSMALL:
			return "buffer too small";
		case DSERR_CONTROLUNAVAIL:
			return "control unavailable";
		case DSERR_UNINITIALIZED:
			return "uninitialized";
		case DSERR_UNSUPPORTED:
			return "unsupported";
		default:
			return "Unknown direct sound error";
		}
}

LPGUID arrayToGUID(JNIEnv *env,jbyteArray GUIDjarray,LPGUID lpGUID){
	if(GUIDjarray != NULL){
		env->GetByteArrayRegion(GUIDjarray,0,sizeof(GUID),(jbyte *)lpGUID);
		return lpGUID;
	}else{
		return NULL;
	}
}