#include "ips_audio_ds_DSMixer.h"
#define ARRAY_SIZE(x) (sizeof(x)/sizeof(*(x)))

const jfloat PLAY_SAMPLERATES[] = {8000,11025,22050,44100,48000,96000};
const jint SAMPLERATES_COUNT=6;

JNIEXPORT jbyteArray JNICALL Java_ips_audio_ds_DSMixer_init(JNIEnv *env,jobject obj,jbyteArray guidArr,jboolean source){
	LPGUID lpGUID=NULL;
	jboolean isCopy;
	if(guidArr != NULL){
		lpGUID=(LPGUID)env->GetByteArrayElements(guidArr,&isCopy);
	}
	if(source){
		LPDIRECTSOUND lpds;
		HRESULT	hr= DirectSoundCreate(lpGUID, &lpds, NULL);
		if(hr==DS_OK){
			jbyteArray lpdsArr=env->NewByteArray(sizeof(LPDIRECTSOUND));
			env->SetByteArrayRegion(lpdsArr,0,sizeof(LPDIRECTSOUND),(jbyte *)&lpds);
			HWND mWindow = GetForegroundWindow();
			if (mWindow == NULL) {
				mWindow = GetDesktopWindow();
			}
			if(lpds->SetCooperativeLevel(mWindow, DSSCL_PRIORITY)!=DS_OK){
				env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Could not set priority cooperative level.");
				return NULL;
			}
			return lpdsArr;
		}else{
			if(hr==DSERR_INVALIDPARAM){
				env->ThrowNew(env->FindClass("java/lang/IllegalArgumentException"),"Invalid parameter with native DirectSound method call");
			}else if(hr==DSERR_OUTOFMEMORY){
				env->ThrowNew(env->FindClass("java/lang/OutOfMemoryError"),"DirectSound: Out of memory");
			}else{
				env->ThrowNew(env->FindClass("ips/audio/ds/DSException"),dsErrToString(hr));
			}
		}
	}else{
		LPDIRECTSOUNDCAPTURE lpdsc;
		HRESULT	hr= DirectSoundCaptureCreate(lpGUID, &lpdsc, NULL);
		if(hr==DS_OK){
			jbyteArray lpdscArr=env->NewByteArray(sizeof(LPDIRECTSOUNDCAPTURE));
			env->SetByteArrayRegion(lpdscArr,0,sizeof(LPDIRECTSOUNDCAPTURE),(jbyte *)&lpdsc);

			return lpdscArr;
		}else{
			if(hr==DSERR_INVALIDPARAM){
				env->ThrowNew(env->FindClass("java/lang/IllegalArgumentException"),"Invalid parameter with native DirectSound method call");
			}else if(hr==DSERR_OUTOFMEMORY){
				env->ThrowNew(env->FindClass("java/lang/OutOfMemoryError"),"DirectSound: Out of memory");
			}else{
				env->ThrowNew(env->FindClass("ips/audio/ds/DSException"),dsErrToString(hr));
			}
		}
	}
	return NULL;
}


JNIEXPORT void JNICALL Java_ips_audio_ds_DSMixer_getCaps(JNIEnv *env, jobject obj,jbyteArray np,jboolean playback){
	
	jboolean isCopy;
	jclass afClass=env->FindClass("javax/sound/sampled/AudioFormat");
	jmethodID afConstructor=env->GetMethodID(afClass,"<init>","(FIIZZ)V");
	jclass dsMixerClass=env->FindClass("ips/audio/ds/DSMixer");
	jmethodID afCallback=env->GetMethodID(dsMixerClass,"addSupportedFormat","(Ljavax/sound/sampled/AudioFormat;)V");
	
	if(playback){
		DSCAPS caps;
		caps.dwSize=sizeof(DSCAPS);
		LPDSCAPS capslp= &caps;
	LPDIRECTSOUND *lpdsp=(LPDIRECTSOUND *)env->GetByteArrayElements(np,&isCopy);
	(*lpdsp)->GetCaps(capslp);
	for(int si=0;si<ARRAY_SIZE(PLAY_SAMPLERATES);si++){
		jfloat sr=PLAY_SAMPLERATES[si];
		DWORD dwFlags=caps.dwFlags;
		if(sr>=caps.dwMinSecondarySampleRate && sr<=caps.dwMaxSecondarySampleRate){
			if(dwFlags & DSCAPS_SECONDARY8BIT){
				if(dwFlags & DSCAPS_SECONDARYMONO){
					jobject af=env->NewObject(afClass,afConstructor,sr,8,1,TRUE,FALSE);
					env->CallVoidMethod(obj,afCallback,af);
				}
				if(dwFlags & DSCAPS_SECONDARYSTEREO){
					jobject af=env->NewObject(afClass,afConstructor,sr,8,2,TRUE,FALSE);
					env->CallVoidMethod(obj,afCallback,af);
				}
			}
			if(dwFlags & DSCAPS_SECONDARY16BIT){
				if(dwFlags & DSCAPS_SECONDARYMONO){
					jobject af=env->NewObject(afClass,afConstructor,sr,16,1,TRUE,FALSE);
					env->CallVoidMethod(obj,afCallback,af);
				}
				if(dwFlags & DSCAPS_SECONDARYSTEREO){
					jobject af=env->NewObject(afClass,afConstructor,sr,16,2,TRUE,FALSE);
					env->CallVoidMethod(obj,afCallback,af);
				}
			}
		}
	}
	}else{
	DSCCAPS ccaps;
	LPDSCCAPS ccapslp=&ccaps;
	ccaps.dwSize=sizeof(DSCCAPS);
	LPDIRECTSOUNDCAPTURE *lpdscp=(LPDIRECTSOUNDCAPTURE *)env->GetByteArrayElements(np,&isCopy);
	(*lpdscp)->GetCaps(ccapslp);
	jint maxChannels=ccaps.dwChannels;
	//printf("DS Channels %d\n",maxChannels);
	fflush(stdout);
	DWORD formats=ccaps.dwFormats;
	
	if((formats & WAVE_FORMAT_1M08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)8000,8,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)8000,8,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}	
	}
	if((formats & WAVE_FORMAT_1M16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)11025,16,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_1S08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)11025,8,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)11025,8,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_1S16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)11025,16,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)11025,16,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_2M08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)22050,8,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_2M16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)22050,16,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_2S08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)22050,8,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)22050,8,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}	
	if((formats & WAVE_FORMAT_2S16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)22050,16,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)22050,16,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_44M08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)44100,8,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_44M16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)44100,16,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_44S08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)44100,8,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)44100,8,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_44S16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)44100,16,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(int chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)44100,16,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_48M08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)48000,8,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_48M16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)48000,16,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_48S08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)48000,8,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)48000,8,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_48S16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)48000,16,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)48000,16,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_96M08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)96000,8,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_96M16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)96000,16,1,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
	}
	if((formats & WAVE_FORMAT_96S08)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)96000,8,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)96000,8,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	if((formats & WAVE_FORMAT_96S16)>0){
		jobject af=env->NewObject(afClass,afConstructor,(jfloat)96000,16,2,TRUE,FALSE);
		env->CallVoidMethod(obj,afCallback,af);
		for(jint chs=3;chs<=maxChannels;chs++){
			jobject afMch=env->NewObject(afClass,afConstructor,(jfloat)96000,16,chs,TRUE,FALSE);
			env->CallVoidMethod(obj,afCallback,afMch);
		}
	}
	}
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSMixer_release(JNIEnv *env,jobject obj,jbyteArray lpdscArr){
	jboolean isCopy;
	LPDIRECTSOUNDCAPTURE *lpds=(LPDIRECTSOUNDCAPTURE *)env->GetByteArrayElements(lpdscArr,&isCopy);
	if(*lpds != NULL){
		(*lpds)->Release();
#ifdef ips_audio_ds_DSMixer_DEBUG
		printf("DSJS native released mixer %x\n",(*lpds));
		fflush(stdout);
#endif
	}
}