#include "ips_audio_ds_DSMixer.h"
#include "ips_audio_ds_DSTargetDataLine.h"

static const char* JAVA_CLASS_NAME="ips/audio/ds/DSTargetDataLine";

LPDSTDL getNativeTargetDataLine(JNIEnv *env,jobject obj){
	return (LPDSTDL) getNativeDataLine(env,obj);
}

JNIEXPORT jbyteArray JNICALL Java_ips_audio_ds_DSTargetDataLine_open(JNIEnv* env, jobject obj,jbyteArray jDevGuid,jfloat samplesPerSec,jint bitsPerSample,jint frameSize,jint channels,jint bufferSize){
	LPDSTDL lptdl=new DSDataLine();
	memset(lptdl,0,sizeof(DSDataLine));

	LPGUID devLpGuid=NULL;
	jboolean isCopy;
	if(jDevGuid != NULL){
		devLpGuid=(LPGUID)env->GetByteArrayElements(jDevGuid,&isCopy);
	}
	//LPDIRECTSOUNDCAPTURE lpdsc;
	HRESULT	hr= DirectSoundCaptureCreate(devLpGuid, &(lptdl->dsCdev), NULL);
	if(hr!=DS_OK){
		if(hr==DSERR_INVALIDPARAM){
			env->ThrowNew(env->FindClass("java/lang/IllegalArgumentException"),"Invalid parameter with native DirectSound method call");
		}else if(hr==DSERR_OUTOFMEMORY){
			env->ThrowNew(env->FindClass("java/lang/OutOfMemoryError"),"DirectSound: Out of memory");
		}else{
			env->ThrowNew(env->FindClass("ips/audio/ds/DSException"),dsErrToString(hr));
		}
		delete lptdl;
		return NULL;
	}
	//LPDIRECTSOUNDCAPTURE *cDevP=(LPDIRECTSOUNDCAPTURE *)env->GetByteArrayElements(np,&isCopy);
	//LPDIRECTSOUNDCAPTURE cDev=(*cDevP);
	LPUNKNOWN pUnkOuter=0;
	//WAVEFORMATEX format;

	//WORD blockAlign=(WORD)((bitsPerSample * channels) / 8); 
	WORD blockAlign=(WORD)frameSize;
	
	//lptdl->formatExt.Format.wFormatTag=WAVE_FORMAT_PCM; 
	lptdl->formatExt.Format.wFormatTag=WAVE_FORMAT_EXTENSIBLE;
	lptdl->formatExt.Format.nChannels=(WORD)channels; 
	lptdl->formatExt.Format.nSamplesPerSec=(DWORD)samplesPerSec; 
	lptdl->formatExt.Format.nAvgBytesPerSec=(DWORD)samplesPerSec*blockAlign; 
	lptdl->formatExt.Format.nBlockAlign=blockAlign; 
	// DS docs: "container size" 
	//lptdl->formatExt.Format.wBitsPerSample=(WORD)bitsPerSample; 
	lptdl->formatExt.Format.wBitsPerSample=(WORD)(frameSize/channels)*8;
	//lptdl->formatExt.Format.cbSize=sizeof(WAVEFORMATEXTENSIBLE)-sizeof(WAVEFORMATEX);
	lptdl->formatExt.Format.cbSize=22;
	lptdl->formatExt.Samples.wValidBitsPerSample=(WORD)bitsPerSample;
	//lptdl->formatExt.dwChannelMask=0xFFFFFFFF;
	lptdl->formatExt.dwChannelMask=0;
	lptdl->formatExt.SubFormat=KSDATAFORMAT_SUBTYPE_PCM;

	lptdl->captureBufDesc.dwSize=sizeof(DSCBUFFERDESC);
	lptdl->captureBufDesc.dwFlags=0;
	//captureBufDesc.dwBufferBytes=DSBSIZE_MAX;
	lptdl->captureBufDesc.dwBufferBytes=bufferSize;
	lptdl->captureBufDesc.dwReserved=0;
	lptdl->captureBufDesc.lpwfxFormat=&lptdl->formatExt.Format;
	lptdl->captureBufDesc.dwFXCount=0;
	lptdl->captureBufDesc.lpDSCFXDesc=NULL;
	//LPDIRECTSOUNDCAPTUREBUFFER lpdscb;

	//lptdl->capturePosition=0;
	lptdl->readPosition=0;
	//lptdl->bufferSize=bufferSize;
	lptdl->lpdscb=NULL;
	lptdl->active=false;
	lptdl->running=false;

	hr=lptdl->dsCdev->CreateCaptureBuffer(&(lptdl->captureBufDesc),(LPDIRECTSOUNDCAPTUREBUFFER *)&(lptdl->lpdscb),pUnkOuter);
	if(hr!=DS_OK){
		if(hr==DSERR_BADFORMAT){
			env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Bad audio format.");
		}else if(hr==DSERR_GENERIC){
			env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Generic DirectSound error.");
		}else if(hr==DSERR_NODRIVER){
			env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"No driver error.");
		}else if(hr==DSERR_OUTOFMEMORY){
			env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Out of memory.");
		}else if(hr==DSERR_UNINITIALIZED){
			env->ThrowNew(env->FindClass("javax/sound/sampled/LineUnavailableException"),"Uninitialized.");
		}
		lptdl->dsCdev->Release();
		delete lptdl;
		return NULL;
	}else{
		//cDev->used=true;
#ifdef ips_audio_ds_DSTargetDataLine_DEBUG
		printf("Capture buffer openend: %x\n",lptdl);
#endif
		jbyteArray tdlArr=env->NewByteArray(sizeof(LPDSTDL));
		env->SetByteArrayRegion(tdlArr,0,sizeof(LPDSTDL),(jbyte *)(&lptdl));
		return tdlArr;
	}
}



HRESULT available(LPDSTDL lptdl,jint *available){
	DWORD dsReadPosition;
	HRESULT hr=lptdl->lpdscb->GetCurrentPosition(NULL,&dsReadPosition);
	if(hr==DS_OK){
		int captureOffset=lptdl->readPosition % lptdl->captureBufDesc.dwBufferBytes;
		int avail=dsReadPosition-captureOffset;
		// directsound buffer is circular
		if(avail<0)avail+=lptdl->captureBufDesc.dwBufferBytes;
		(*available)=avail;
	}
	return hr;
}

JNIEXPORT jint JNICALL Java_ips_audio_ds_DSTargetDataLine_available(JNIEnv *env, jobject obj){
	LPDSTDL lptdl=getNativeTargetDataLine(env,obj);
	jint avail;
	HRESULT hr=available(lptdl,&avail);
	if(hr==DS_OK){
		return avail;
	}else{
		return 0;
	}
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSTargetDataLine_nStart(JNIEnv* env, jobject obj){
LPDSTDL lptdl=getNativeTargetDataLine(env,obj);
if(lptdl!=NULL && lptdl->lpdscb!=NULL){
	if(!lptdl->active){
		lptdl->lpdscb->Start(DSCBSTART_LOOPING);
	}
	lptdl->active=true;
}
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSTargetDataLine_flush(JNIEnv* env, jobject obj){
	LPDSTDL lptdl=getNativeTargetDataLine(env,obj);
//if(lptdl!=NULL && lptdl->lpdscb!=NULL && lptdl->readPosition>0){
	if(lptdl!=NULL && lptdl->lpdscb!=NULL){
	DWORD dsReadPosition;
	HRESULT hr=lptdl->lpdscb->GetCurrentPosition(NULL,&dsReadPosition); 
	if(hr==DS_OK){
		//fprintf(stderr,"TDL flush DS readpos: %d !\n",dsReadPosition);
		//fprintf(stderr,"TDL flush readpos: %d !\n",lptdl->readPosition);
		//fflush(stderr);
		lptdl->readPosition=dsReadPosition;
	
	}
	//printf("TDL native flushed\n");
	//fflush(stdout);
}
}

JNIEXPORT jlong JNICALL Java_ips_audio_ds_DSTargetDataLine_getLongFramePosition(JNIEnv* env, jobject obj){
	LPDSTDL lptdl=getNativeTargetDataLine(env,obj);
if(lptdl!=NULL && lptdl->lpdscb!=NULL){
	DWORD dsCapturePosition;
	jlong readPos=lptdl->readPosition;
	HRESULT hr=lptdl->lpdscb->GetCurrentPosition(&dsCapturePosition,NULL); 
	if(hr==DS_OK){
		jlong captureOffset=readPos % lptdl->captureBufDesc.dwBufferBytes;
	jlong captureAvail=dsCapturePosition-captureOffset;
	if(captureAvail<0)captureAvail+=lptdl->captureBufDesc.dwBufferBytes;
	return (readPos+captureAvail)/lptdl->formatExt.Format.nBlockAlign;
	}
return 0;
}
return 0;
}

JNIEXPORT jint JNICALL Java_ips_audio_ds_DSTargetDataLine_read(JNIEnv* env, jobject obj,jbyteArray buf,jint offset,jint len){
	LPDSTDL lptdl=getNativeTargetDataLine(env,obj);
jint read=0;
if(lptdl!=NULL && lptdl->lpdscb!=NULL){
	LPVOID pvAudioPtr1;
	DWORD dwAudioBytes1=0;
	LPVOID pvAudioPtr2;
	DWORD dwAudioBytes2=0;
	//LPDWORD 
	if(!lptdl->active){
		return 0;
	}
	
int avail=0;
//DWORD capturePosition;
DWORD dsReadPosition;
int captureOffset=0;
	do{
	lptdl->lpdscb->GetCurrentPosition(NULL,&dsReadPosition); 
	captureOffset=lptdl->readPosition % lptdl->captureBufDesc.dwBufferBytes;
#ifdef ips_audio_ds_DSTargetDataLine_DEBUG
	printf("Readpos %d captureOffset %d my Read pos %d buffersize %d\n",readPosition,captureOffset,lptdl->readPosition,lptdl->bufferSize);
#endif
	avail=dsReadPosition-captureOffset;
	if(avail<0)avail+=lptdl->captureBufDesc.dwBufferBytes;
	if(avail==0)Sleep(10);
	}while(lptdl->active && avail==0);
	if(!lptdl->active){
		return 0;
	}
	int locksize=avail;
	if(locksize>len)locksize=len;
#ifdef ips_audio_ds_DSTargetDataLine_DEBUG
	printf("Reading %d\n",locksize);
	fflush(stdout);
#endif
	HRESULT hr=lptdl->lpdscb->Lock(captureOffset,locksize,&pvAudioPtr1,&dwAudioBytes1,&pvAudioPtr2,&dwAudioBytes2,0);
	if(hr!=DS_OK){
		fprintf(stderr,"TDL buffer lock error!\n");
		fflush(stderr);
		return 0;
	}
	if((dwAudioBytes1)>0){
		
	env->SetByteArrayRegion(buf,offset,dwAudioBytes1,(jbyte *)pvAudioPtr1);
	read+=dwAudioBytes1;
	}
	if(pvAudioPtr2!=NULL && dwAudioBytes2>0){
#ifdef ips_audio_ds_DSTargetDataLine_DEBUG
		printf("Buffer wrap %d bytes\n",dwAudioBytes2);
#endif
		env->SetByteArrayRegion(buf,offset+dwAudioBytes1,dwAudioBytes2,(jbyte *)pvAudioPtr2);
		read+=(dwAudioBytes2);
	}
	hr=lptdl->lpdscb->Unlock(pvAudioPtr1,dwAudioBytes1,pvAudioPtr2,dwAudioBytes2);
	if(hr!=DS_OK){
		fprintf(stderr,"TDL buffer unlock error\n");
		fflush(stderr);
	}
	lptdl->readPosition+=read;
	if(!lptdl->running && read>0){
		lptdl->running=true;
	}
}else{
	//jclass ioExcClass=env->FindClass("java/io/IOException");
	fprintf(stderr,"internal error (no capture buffer)\n");
	fflush(stderr);
	return 0;
}

return read;
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSTargetDataLine_nStop(JNIEnv* env, jobject obj){
	LPDSTDL lptdl=getNativeTargetDataLine(env,obj);
	if(lptdl!=NULL){
		if(lptdl->lpdscb!=NULL && lptdl->active){
			lptdl->lpdscb->Stop();
		}
		lptdl->active=false;
		lptdl->running=false;
	}
}



JNIEXPORT void JNICALL Java_ips_audio_ds_DSTargetDataLine_release(JNIEnv* env, jobject obj){
LPDSTDL lptdl=getNativeTargetDataLine(env,obj);
if(lptdl!=NULL){
	if(lptdl->lpdscb!=NULL){
		lptdl->lpdscb->Release();
		lptdl->lpdscb=NULL;
	}
	if(lptdl->dsCdev!=NULL){
		lptdl->dsCdev->Release();
		lptdl->dsCdev=NULL;
	}
	delete lptdl;
#ifdef ips_audio_ds_DSDataLine_DEBUG
	printf("TDL buffer %x release.\n",lptdl);
#endif
	}

	
}