#include "ips_audio_ds_DSDataLine.h"

static const char* JAVA_CLASS_NAME="ips/audio/ds/DSDataLine";

LPDSDL getNativeDataLine(JNIEnv *env,jobject obj){
	jclass jClass=env->FindClass(JAVA_CLASS_NAME);
	jfieldID lpdsbFId=env->GetFieldID(jClass,"nativeDl","[B");
	jbyteArray nativeDlArr=(jbyteArray)env->GetObjectField(obj,lpdsbFId);
	if(nativeDlArr!=NULL){
		jboolean isCopy;
		LPDSDL *nativeDl=(LPDSDL *)(env->GetByteArrayElements(nativeDlArr,&isCopy));
		if(nativeDl==NULL){
			fprintf(stderr,"Error getting native DL array\n");
			fflush(stderr);
			return NULL;
		}
		return (*nativeDl);
	}else{
		return NULL;
	}
}

JNIEXPORT jint JNICALL Java_ips_audio_ds_DSDataLine_getBufferSize(JNIEnv *env, jobject obj){
	LPDSDL lpdl=getNativeDataLine(env,obj);
	if(lpdl!=NULL){
		return lpdl->bufDesc.dwBufferBytes;
	}else{
		return -1;
	}
}

JNIEXPORT jint JNICALL Java_ips_audio_ds_DSDataLine_getMaxBufferSize(JNIEnv *env, jobject obj){
	return DSBSIZE_MAX;
}

JNIEXPORT jint JNICALL Java_ips_audio_ds_DSDataLine_getMinBufferSize(JNIEnv *env, jobject obj){
	return DSBSIZE_MIN;
}

JNIEXPORT jboolean JNICALL Java_ips_audio_ds_DSDataLine_isActive(JNIEnv* env, jobject obj){
	LPDSDL lpdl=getNativeDataLine(env,obj);
	if(lpdl!=NULL && lpdl->lpdsb!=NULL){
		return lpdl->active;
	}else{
		return false;
	}
}


JNIEXPORT jboolean JNICALL Java_ips_audio_ds_DSDataLine_isRunning(JNIEnv* env, jobject obj){
	LPDSDL lpdl=getNativeDataLine(env,obj);
	if(lpdl!=NULL && lpdl->lpdsb!=NULL){
		return lpdl->running;
	}else{
		return false;
	}
}
