

#include "ips_audio_ds_DSMixerProvider.h"
using namespace std;



LPDSCDEV defaultCaptureDevice;
std::vector<LPDSCDEV> captureMixerList;

JNIEXPORT void JNICALL Java_ips_audio_ds_DSMixerProvider_init(JNIEnv *env, jobject obj) {
	//HRESULT coInitResult=CoInitializeEx(NULL,0);
	// This caused problems with the ASIO driver which initializes
	// with CoInitialize(0); (concurrency model as single-thread apartment (STA))
	// see asiolist.cpp constructor AsioDriverList::AsioDriverList ()
	
	// HRESULT coInitResult=CoInitialize(0); // OK, but deprecated

	HRESULT coInitResult=CoInitializeEx(NULL,COINIT_APARTMENTTHREADED); // should be compatible to ASIO

#ifdef ips_audio_ds_DSMixerProvider_DEBUG
	printf("COM Initialized\n");
	fflush(stdout);
#endif
}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSMixerProvider_enumerateDevices(JNIEnv *env, jobject obj) {
	if (FAILED(DirectSoundCaptureEnumerate((LPDSENUMCALLBACK)DSCEnumProc,env)))
    {
		env->ThrowNew(env->FindClass("ips/audio/ds/DSException"),"Could not enumerate DirectSound capture devices");	
		return;
	}
//	printf("Enumerating capture devices:\n");
	
	if (FAILED(DirectSoundEnumerate((LPDSENUMCALLBACK)DSEnumProc,env)))
    {
		env->ThrowNew(env->FindClass("ips/audio/ds/DSException"),"Could not enumerate DirectSound playback devices");	
		return;
	}
//	printf("Enumerating devices:\n");
	

	return;
}

void printGUID(LPGUID lpguid){
	if(lpguid!=NULL){
		printf("GUID: %.4lx-%.2hx-%.2hx-%.2hx%.2hx-%.2hx%.2hx%.2hx%.2hx%.2hx%.2hx\n",lpguid->Data1,lpguid->Data2,lpguid->Data3,lpguid->Data4[0],lpguid->Data4[1],lpguid->Data4[2],lpguid->Data4[3],lpguid->Data4[4],lpguid->Data4[5],lpguid->Data4[6],lpguid->Data4[7]);
	}
}

BOOL CALLBACK DSEnumProc(LPGUID lpGUID, 
						 LPCTSTR lpszDesc,
						 LPCTSTR lpszDrvName, 
						 LPVOID lpContext )
{	
	JNIEnv* env=(JNIEnv*)lpContext;
	jclass jClass=env->FindClass("ips/audio/ds/DSMixerProvider");
	jmethodID mId=env->GetStaticMethodID(jClass,"nextPlaybackDevice","([B[B)V");
	if(mId==NULL){
		fprintf(stderr,"Could not find static method\n");
	}
	
	jbyteArray lpTemp = NULL;
	
	if (lpGUID != NULL)  //  NULL only for "Primary Sound Driver".
	{
#ifdef ips_audio_ds_DSMixerProvider_DEBUG
		printGUID(lpGUID);
#endif
		if ((lpTemp=env->NewByteArray(sizeof(GUID)))==NULL)return FALSE;
		env->SetByteArrayRegion(lpTemp,0,sizeof(GUID),(jbyte *)lpGUID);	
	}

	jbyteArray descTmp=env->NewByteArray((jsize)strlen(lpszDesc));
	env->SetByteArrayRegion(descTmp,0,(jsize)strlen(lpszDesc),(jbyte *)lpszDesc);
	env->CallStaticVoidMethod(jClass,mId,lpTemp,descTmp);
	return(TRUE);
}



BOOL CALLBACK DSCEnumProc(LPGUID lpGUID, 
						  LPCTSTR lpszDesc,
						  LPCTSTR lpszDrvName, 
						  LPVOID lpContext )
{
	JNIEnv* env=(JNIEnv*)lpContext;
	jclass jClass=env->FindClass("ips/audio/ds/DSMixerProvider");
	jmethodID mId=env->GetStaticMethodID(jClass,"nextCaptureDevice","([B[B)V");
	if(mId==NULL){
		fprintf(stderr,"Could not find static method\n");
	}
	
	jbyteArray lpTemp = NULL;
	
	if (lpGUID != NULL)  //  NULL only for "Primary Sound Driver".
	{
		//printGUID(lpGUID);
		if ((lpTemp=env->NewByteArray(sizeof(GUID)))==NULL)return FALSE;
		env->SetByteArrayRegion(lpTemp,0,sizeof(GUID),(jbyte *)lpGUID);	
	}

	jbyteArray descTmp=env->NewByteArray((jsize)strlen(lpszDesc));
	env->SetByteArrayRegion(descTmp,0,(jsize)strlen(lpszDesc),(jbyte *)lpszDesc);
	env->CallStaticVoidMethod(jClass,mId,lpTemp,descTmp);
	return(TRUE);
}

//JNIEXPORT void JNICALL Java_ips_audio_ds_DSMixerProvider_getCaptureMixer(JNIEnv *env, jobject obj,jbyteArray guidjarray) {
//	
//	HRESULT hr =DS_OK;
//	LPDIRECTSOUNDCAPTURE lpds=NULL;
//	GUID guid;
//	LPGUID lpguid=arrayToGUID(env,guidjarray,&guid);
//
//	printGUID(lpguid);
//	/*
//	TODO
//	es gibt keine eindeutige ID fuer das default device (lpguid==NULL).
//	Wenn der user das Default device aendert (oder per USB Hotplug) wird der falsche cache Eintrag benutzt !!
//	Eventuell sollten wir das default device gar nicht cachen.
//	*/
//	
//	
//		LPDSCDEV dev=getCaptureDevice(lpguid);
//		if(dev==NULL){
//			LPDSCDEV newDev=createCaptureMixer(lpguid);
//			captureMixerList.push_back(newDev);
//		}
//	
//}


//LPDSCDEV getCaptureDevice(LPGUID lpguid){
//	LPDSCDEV lpcsDev=NULL;
//	if(lpguid==NULL){
//		if(defaultCaptureDevice!=NULL){
//			if(!defaultCaptureDevice->used){
//				LPDIRECTSOUNDCAPTURE lpds=defaultCaptureDevice->device;
//				if(lpds!=NULL){
//					lpds->Release();
//				}
//				delete defaultCaptureDevice;
//
//				defaultCaptureDevice=createCaptureMixer(lpguid);
//				lpcsDev=defaultCaptureDevice;
//			}
//		}else{
//			defaultCaptureDevice=createCaptureMixer(lpguid);	
//		}
//		lpcsDev=defaultCaptureDevice;
//	}else{
//	int csDevs=captureMixerList.size();
//	for(int i=0;i<csDevs;i++){
//		LPDSCDEV csDev=captureMixerList[i];
//		if((csDev->lpguid!= NULL && lpguid!=NULL) && (IsEqualGUID(csDev->guid,*lpguid))){
//			lpcsDev=csDev;
//			printf("using cached device\n");
//			break;
//		}
//	}}
//	return lpcsDev;
//}

JNIEXPORT void JNICALL Java_ips_audio_ds_DSMixerProvider_release(JNIEnv *env, jobject obj){
	for(unsigned int i=0;i<captureMixerList.size();i++){
		LPDSCDEV cDev=captureMixerList[i];
		cDev->device->Release();
	}
	captureMixerList.clear();
	CoUninitialize();
#ifdef ips_audio_ds_DSMixerProvider_DEBUG
	printf("COM Uninitialized\n");
	fflush(stdout);
#endif
}
