
package ips.audio.ds;

import java.util.Vector;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.TargetDataLine;


/**
 * Implements the mixer interface for DirectSound Java Sound implementation
 * 
 * @author Klaus Jaensch, Institute of Phonetics, klausj@phonetik.uni-muenchen.de
 * 
 */

public class DSMixer implements Mixer, Runnable {

	final static boolean DEBUG = false;

	//private String name;
	private DSMixerInfo minfo;
	
	boolean open = false;

	private Line.Info linfo;
	private DataLine.Info tlDataLineInfo = null;
	private DataLine.Info slDataLineInfo = null;

	private Control[] controls = new Control[0];
	private DSTargetDataLine tdl = null;
	private DSSourceDataLine sdl = null;
	
	//private AudioFormat[] suppSourceFormats;
	private Vector<AudioFormat> tmpSupportedTargetFormats;
	private AudioFormat[] suppTargetFormats;

	private static Mixer.Info openedMixerInfo = null;

//	public DSMixer(MixerProvider provider, String driverName) {
//		this.provider = provider;
//		this.name = driverName;
//		//minfo = new DSMixerInfo(driverName + " (DSJavaSound)",false);
//		linfo = new Line.Info(Mixer.class);
//	}

	private native byte[] init(byte[] guid,boolean source) throws IllegalArgumentException,DSException;
	
	private native void release(byte[] lpdsc);
	private byte[] lpdsc;
	
	private DSException nativeException=null;
	
	public DSMixer(DSMixerInfo minfo) throws IllegalArgumentException,DSException {
		this.minfo=minfo;
		linfo=new Line.Info(getClass());
		//lpdsc=init(minfo.getNativeGUID(),minfo.isSource());
		//release(lpdsc);
		if(DEBUG)System.out.println("Constructed: "+this);
	}
	
	public String toString(){
		return "DSMixer source: "+minfo.isSource()+" native pointer: "+DSMixerProvider.toHexString(lpdsc, true);
	}

	public void open() throws LineUnavailableException {

		if (! open)
			return;
		
	
		openedMixerInfo = minfo;
		open = true;
	}

	/**
	 * Initializes the native DirectSound driver 
	 * @return true on success
	 */

	public native boolean initialize();
	public native boolean nOpen();
	
	public native double getSampleRate();

	
	

	/* Line interface */

	public void addLineListener(LineListener listener) {
	}
	public synchronized void close() {
//		if (tdl != null && tdl.isOpen()) {
//			tdl.close();
//		}
//		tdl = null;
//		if (sdl != null && sdl.isOpen()) {
//			sdl.close();
//		}
//		sdl = null;
	
		open = false;
		openedMixerInfo = null;
		if (DEBUG)
			System.out.println("DSMixer closed (released).");
	}
	public Control getControl(Control.Type control) {

		return null;
	}
	public Control[] getControls() {

		return controls;
	}
	public Line.Info getLineInfo() {
		return linfo;
	}
	public boolean isControlSupported(Control.Type control) {
		return false;
	}
	public boolean isOpen() {
		return open;
	}

	public void removeLineListener(LineListener listener) {
	}

	/* Mixer interface */
	public Line getLine(Line.Info info) throws LineUnavailableException {
		if (info.matches(linfo))
			return this;
//
		if(minfo.isSource()){
			if(slDataLineInfo==null){
				getSourceLineInfo();
			}
			if (slDataLineInfo != null && info.matches(slDataLineInfo))
				return sdl;
		}else{
		if(tlDataLineInfo==null){
			getTargetLineInfo();
		}
		if (tlDataLineInfo != null && info.matches(tlDataLineInfo))
			return tdl;
		}
	

		// TODO check ports
		throw new IllegalArgumentException("No line matching info: "+info+" found");
		//return null;
	}

	public int getMaxLines(Line.Info info) {
		// TODO for now we only allow one line
		return 1;
	}

	public Mixer.Info getMixerInfo() {
		return minfo;
	}

	public Line.Info[] getSourceLineInfo() {
		
			
		return getSourceLineInfo(null);

	}

	public Line.Info[] getSourceLineInfo(Line.Info info) {
		if(!minfo.isSource())return new Line.Info[0];
		if(slDataLineInfo==null && nativeException==null){
			tmpSupportedTargetFormats=new Vector<AudioFormat>();
			try {
				lpdsc=init(minfo.getNativeGUID(),minfo.isSource());
			} catch (IllegalArgumentException e) {
				lpdsc=null;
				e.printStackTrace();
			} catch (DSException e) {
				lpdsc=null;
				nativeException=e;
				e.printStackTrace();
			}
			// BUG here must be TRUE!!
			// may have caused the problem !!
			// 1. try to get the caps
			// 2. test
			// 3. remove the code which releases the device interface 
			// 4. test again
			// 5. remove code which creates/releases device interface on line open/close
			// 6. test again
			if(lpdsc!=null){
				getCaps(lpdsc,true);
				release(lpdsc);
				lpdsc=null;
				//getCaptureCaps(minfo.getNativeGUID());
				slDataLineInfo=new DataLine.Info(SourceDataLine.class,tmpSupportedTargetFormats.toArray(new AudioFormat[0]),DSDataLine.getMinBufferSize(),DSDataLine.getMaxBufferSize());
				sdl=new DSSourceDataLine(this);
			}
		}
		if(info==null || info.matches(slDataLineInfo)){
		return new Line.Info[]{slDataLineInfo};
		}else{
		return new Line.Info[0];
		}
	}

	public Line[] getSourceLines() {

//		if (open && sdl != null && sdl.isOpen()) {
//			return new Line[] { sdl };
//		}
		if(sdl==null){
			getSourceLineInfo();
		}
		return new Line[]{sdl};
	}
	
	private native void getCaps(byte[] np,boolean source);
	
	
	public Line.Info[] getTargetLineInfo() {
		return getTargetLineInfo(null);
	}
	
//	/**
//	 * Supported channels. This may be more than two.
//	 * See DSCCAPS structure DWORD dwChannels
//	 * @param supportedChannels
//	 */
//	private void setSupportedChannels(int supportedChannels){
//		
//	}
	public void addSupportedFormat(AudioFormat af){
		tmpSupportedTargetFormats.add(af);
		if(DEBUG)System.out.println("Supported format: "+af);
	}

	public Line.Info[] getTargetLineInfo(Line.Info info) {
		if(minfo.isSource())return new Line.Info[0];
		if(tlDataLineInfo==null && nativeException==null){
			tmpSupportedTargetFormats=new Vector<AudioFormat>();
			try {
				lpdsc=init(minfo.getNativeGUID(),minfo.isSource());
			} catch (IllegalArgumentException e) {
				lpdsc=null;
				e.printStackTrace();
			} catch (DSException e) {
				lpdsc=null;
				nativeException=e;
				e.printStackTrace();
			}
			// if no capture device available
			// Direct sound enumerates only Primary sound device and fails on initialize
			// (DirectSoundCaptureCreate8 return an unknown error value)
			if(lpdsc!=null){
				getCaps(lpdsc,false);
				release(lpdsc);
				lpdsc=null;

				//getCaptureCaps(minfo.getNativeGUID());
				tlDataLineInfo=new DataLine.Info(TargetDataLine.class,tmpSupportedTargetFormats.toArray(new AudioFormat[0]),DSDataLine.getMinBufferSize(),DSDataLine.getMaxBufferSize());
				tdl=new DSTargetDataLine(this);
			}
		}
		if(info==null || info.matches(tlDataLineInfo)){
		return new Line.Info[]{tlDataLineInfo};
		}else{
		return new Line.Info[0];
		}
	}

	public Line[] getTargetLines() {

		if(tdl==null){
			getTargetLineInfo();
		}
		return new Line[]{tdl};
	}

	public boolean isLineSupported(Line.Info info) {
		
		if (info.matches(linfo))
			return true;
		
		if(TargetDataLine.class.isAssignableFrom(info.getLineClass())){
		getTargetLineInfo();
		if (info.matches(tlDataLineInfo))
			return true;
		}else if(SourceDataLine.class.isAssignableFrom(info.getLineClass())){
			getSourceLineInfo();
			if (info.matches(slDataLineInfo))
				return true;
		}
		return false;
	}

	public boolean isSynchronizationSupported(
		Line[] lines,
		boolean maintainSync) {
		return false;
	}

	public void synchronize(Line[] lines, boolean maintainSync) {
	}

	public void unsynchronize(Line[] lines) {
	}
	/* (non-Javadoc)
	 * @see java.lang.Runnable#run()
	 */
	public void run() {
		if (DEBUG)
			System.out.println("Running shutdown hook...");
		//rt.removeShutdownHook(cleanupThread);	
		close();
		//release();

	}


//	public String getName() {
//		return Charset.forName("ASCII").decode(ByteBuffer.wrap(minfo.getDriverName())).toString();
//	}

//	public DSSourceDataLine getSdl() {
//		return sdl;
//	}

//	public void setSdl(DSSourceDataLine sdl) {
//		this.sdl = sdl;
//	}
	
	public byte[] getLpdsc() {
		return lpdsc;
	}
	
	protected void finalize() throws Throwable{
		System.out.println("Releasing "+this);
		release(lpdsc);
		super.finalize();
		if(DEBUG)System.out.println("Mixer finalized");
	}

	public static void main(String args[]) {
		
		//Mixer.Info m1=new Mixer.Info("abc","def","ghi","jkl");
		//Mixer.Info m2=new Mixer.Info("abc","def","ghi","jkl");
		AudioFormat format =new AudioFormat(44100,16,2,true,true);
		DataLine.Info tdlInfo = new DataLine.Info(TargetDataLine.class, format);
		Mixer.Info[] mi = AudioSystem.getMixerInfo();
		System.out.println("Got mixer infos");
		for (int i = 0; i < mi.length; i++) {
//			System.out.println("Mixer: " + mi[i]);
//			System.out.println("Description: " + mi[i].getDescription());
//			System.out.println("Class: " + mi[i].getClass().getName());
			if (mi[i] instanceof DSMixerInfo) {
				System.out.println("Using/creating IPS DS Mixer: " + mi[i].getName());
				Mixer mix = AudioSystem.getMixer(mi[i]);
				TargetDataLine tdl = null;
				try {
					tdl = (TargetDataLine) mix.getLine(tdlInfo);
					tdl.open(format);
					tdl.start();
//					int av=0;
//					do{
//						av=tdl.available();
//					System.out.println("Available: "+av);
					Thread.sleep(50);
//					}while(av==0);
					tdl.stop();
					tdl.close();
				} catch (LineUnavailableException e) {
					System.err.println("Cannot get input line for " + format);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				mix=null;
				
//				
//				tdl.start();
				
			}
			
			
		}
		for (int i = 0; i < mi.length; i++) {

			if (mi[i] instanceof DSMixerInfo) {
				System.out.println("Using IPS DS Mixer: " + mi[i].getName());
				Mixer mix = AudioSystem.getMixer(mi[i]);
				Line.Info[] lInfos=mix.getTargetLineInfo();
				mix=null;
			}
			
			
		}
		
			System.gc();
			try {
				Thread.sleep(500);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			System.gc();
		System.exit(0);
	}

	public DSMixerInfo getMinfo() {
		return minfo;
	}
	

	
}
