package ips.audio.ds;

import java.io.File;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;

import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.spi.MixerProvider;

public class DSMixerProvider extends MixerProvider {

	final static boolean DEBUG = false;
	final static String NATIVE_LIB_LOCATION_KEY="ips.dsjavasound.nativelib";
	public final static String SERVICE_DESCRIPTION_FILE_PATH="ipsk.audio.ajs.MixerProviderServiceDescriptor.xml";
	private final static String META_PATH="META-INF";
	private final static String META_SERVICES_PATH=META_PATH+"/services/";
	private static boolean useAJSSuffix=false;
	static private Vector<DSMixerInfo> queryMixerInfos=new Vector<DSMixerInfo>();
	//static private Vector<Mixer.Info> queryPlaybackMixerInfos;
	static private Hashtable<DSMixerInfo,DSMixer> mixers=new Hashtable<DSMixerInfo, DSMixer>();
	
	static {
		if (DEBUG)
			System.out.println("DirectSound AJS...");
		String dllLocation=null;
		try{
			dllLocation=System.getProperty(NATIVE_LIB_LOCATION_KEY);	
		}catch(SecurityException se){
			//OK no debug mode, continue
		}
		
		if (dllLocation!=null){
			if(DEBUG)System.out.println("DirectSound-Java library loading ... ");
			File dsLib=new File(dllLocation);
			if(!dsLib.exists()){
				System.err.println("DSJavaSound library not found!");
			}
			System.load(dllLocation);
			
		}else{
			// Workaround for Windows MSI installation:
			// If the MSI installs a 32-bit application and the
			// launches a 64-bit JRE the expansion of
			// -Djava.library.path="%EXEDIR%\%PROCESSOR_ARCHITECTURE%"
			// points to the x86/ directory, but we need an 64-bit DLL from AMD64/ directory
			// Only the application itself is able to determine in which 
			// in which JRE it runs.
			// Just try and error here. Other possible solution:
			// build name from "os.arch" property or build complete path
			// java.library.path\os.arch\DSJavaSound.dll
			// 
			
			try{
				System.loadLibrary("DSJavaSound");
			}catch(Error e1){
				try{
					System.loadLibrary("DSJavaSound_amd64");
				}catch(Error e2){
					System.loadLibrary("DSJavaSound_x86");
				}
			}
		}
		if (DEBUG)
			System.out.println("DirectSound driver loaded");
		
		
//		DSMixerProvider dsmp=new DSMixerProvider();
//		dsmp.init();
//		if(DEBUG) {
//			System.out.println("DirectSound initialized (COM initialized)");
//		}
//		
	}
	
	/**
	 * initializes MS COM library
	 */
	public native void init();
	
	public  DSMixerProvider() {
		super();
		init();
		URL sdURL=null;
		String ajsXmlServiceDescriptorPath=META_SERVICES_PATH+SERVICE_DESCRIPTION_FILE_PATH;
		Class cls=getClass();
		ClassLoader classLoader=cls.getClassLoader();
		if(classLoader!=null){
			sdURL=classLoader.getResource(ajsXmlServiceDescriptorPath);
		}
    	if(sdURL==null){
    		// if no XML descriptor found we are in standard JavaSound mode
    		// and need the suffix " (AJS)"
    		useAJSSuffix=true;
    		if(DEBUG)System.out.println(ajsXmlServiceDescriptorPath+" not found. Switching suffix on");
    	}
		Thread releaseHook=new Thread(){
			public void run() {
				release();
			}	
		};
		Runtime.getRuntime().addShutdownHook(releaseHook);
	
	}
	
	/**
	 * Gets drivers name list
	 * 
	 * @return driver names
	 */
	private native void enumerateDevices() throws DSException;
	
	//private native void getCaptureMixer(byte[] lpGUIDP); 
	private native static void release(); 
	private static void nextPlaybackDevice(byte[] guid, byte[] deviceName){
		if (DEBUG)System.out.println("Play Device: "+guidToString(guid)+" "+deviceName);
		DSMixerInfo dsmInfo=new DSMixerInfo(deviceName,true,guid,useAJSSuffix);
		queryMixerInfos.add(dsmInfo);
	}
	private static void nextCaptureDevice(byte[] guid,byte[] deviceName){
		if (DEBUG)System.out.println("Capture Device: "+guidToString(guid)+" "+deviceName);
		DSMixerInfo dsmInfo=new DSMixerInfo(deviceName,false,guid,useAJSSuffix);
		queryMixerInfos.add(dsmInfo);
	}

	private static char toHexChar(byte nibble){
		if(nibble <10){
		char c='0';
		c+=nibble;
		return c;
		}else{
			char c='a';
			c+=(nibble-10);
			return c;
		}
//		if(nibble==0){
//			return '0';
//		}else if(nibble==1){
//			return '1';
//		}else if(nibble==2){
//			return '2';
//		}else if(nibble==3){
//			return '3';
//		}else if(nibble==4){
//			return '4';
//		}else if(nibble==5){
//			return '5';
//		}else if(nibble==){
//			return '1';
//		}else if(nibble==1){
//			return '1';
//		}else if(nibble==1){
//			return '1';
//		}
	}
	public static String toHexString(byte[] bytes,boolean reverse){
		StringBuffer sb=new StringBuffer();
		if(bytes!=null){
		if(!reverse){
		for(int i=0;i<bytes.length;i++){
			byte b=bytes[i];
			byte nb1=(byte)(b>>4 & 0x0000000f);
			sb.append(toHexChar(nb1));
			byte nb2=(byte) (b & (0x0000000f));
			sb.append(toHexChar(nb2));
		}
		}else{
			for(int i=bytes.length-1;i>=0;i--){
				byte b=bytes[i];
				byte nb1=(byte)(b>>4 & 0x0000000f);
				sb.append(toHexChar(nb1));
				byte nb2=(byte) (b & (0x0000000f));
				sb.append(toHexChar(nb2));
			}
		}
		}
		return sb.toString();
	}
	private static String guidToString(byte[] guid){
		if(guid==null){
			return "[null]";
		}else{
			boolean reverse=true;
			StringBuffer sb=new StringBuffer();
//			sb.append(toHexString(Arrays.copyOfRange(guid,0,4),reverse));
//			sb.append("-");
//			sb.append(toHexString(Arrays.copyOfRange(guid,4,6),reverse));
//			sb.append("-");
//			sb.append(toHexString(Arrays.copyOfRange(guid,6,8),reverse));
//			sb.append("-");
//			sb.append(toHexString(Arrays.copyOfRange(guid,8,10),false));
//			sb.append("-");
//			sb.append(toHexString(Arrays.copyOfRange(guid,10,guid.length),false));
			return sb.toString();
		}
//		if(guid==null)return "null";
//		byte[] guidRev=new byte[4];
//		for(int i=0;i<4;i++){
//			guidRev[i]=guid[3-i];
//		}
//		int i=ByteBuffer.wrap(guidRev).getInt();
//		//int ib=(0x0000ffff & i);
//		String s1=Integer.toHexString(i);
//		if(s1.length() % 2 !=0){
//			s1="0"+s1;
//		}
//		
//		i=(int)guid[5];
//		i=i <<8;
//		i=i | guid[6];
//		i=i & 0x000000ff;
//		String s2=Integer.toHexString(i);
//		if(s2.length() % 2 !=0){
//			s2="0"+s2;
//		}
//		i=(int)guid[7];
//		i=i <<8;
//		i=i | guid[8];
//		i=i & 0x000000ff;
//		String s3=Integer.toHexString(i);
//		if(s3.length() % 2 !=0){
//			s3="0"+s3;
//		}
//		
//		int i=ByteBuffer.wrap(guid).getInt();
//		//int ib=(0x0000ffff & i);
//		String s1=Integer.toHexString(i);
//		if(s1.length() % 2 !=0){
//			s1="0"+s1;
//		}
//		
//		return s;
	}
	public Mixer getMixer(Mixer.Info info) {
		DSMixer mixer=null;
		/*
		 * The equals method of Mixer.Info does not work !
		 * 
		 * if (((Mixer.Info)info).equals(minfos[0])) { System.out.println("Mixer
		 * Info matches"); return mixer; }
		 */
		
	
		for (int i = 0; i < queryMixerInfos.size(); i++) {
			DSMixerInfo mInfo = queryMixerInfos.get(i);
//			if (info.getName().equals(mInfo.getName())) {
//
//				if (DEBUG)
//					System.out.println("Mixer Info " + mInfo.getName()
//							+ " matches");
//				return (DSMixer)queryMixers.get(i);
//			}
			if(mInfo.equals(info)){
				// lookup 
				mixer=mixers.get(mInfo);
				if(mixer==null){
					// not cached, create new
				try {
					mixer=new DSMixer(mInfo);
					mixers.put(mInfo,mixer);
				} catch (DSException e) {
					e.printStackTrace();
				}
				}
				return mixer;
			}
			
		}
		
		throw new IllegalArgumentException();
		
		
	}

	public synchronized Mixer.Info[] getMixerInfo() {
		// query mixers from DS
		
		queryMixerInfos.clear();
		try {
			enumerateDevices();
		} catch (DSException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		return queryMixerInfos.toArray(new Mixer.Info[0]);
		
	}
	
	protected void finalize() throws Throwable{
		super.finalize();
		release();
		if(DEBUG) System.out.println("Mixer provider finalized");
	}
	// public boolean isMixerSupported(Mixer.Info info) {
	// return false;
	// }
	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Runnable#run()
	 */

}
