package ips.audio.ds;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Control;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import javax.sound.sampled.Control.Type;
import javax.sound.sampled.spi.MixerProvider;

public class DSTargetDataLine extends DSDataLine implements TargetDataLine {

	private final static boolean DEBUG=false;
	
	private int bufferSize;
	public DSTargetDataLine(DSMixer mixer){
		super(mixer);
	}
	private native byte[] open(byte[] lpDevGuid,float samplesPerSec,int bitsPerSample,int frameSize,int channels,int bufferSize);
	private native void nStart();
	private native void nStop();
	
	public native void flush();
	private native void release();
	public void open(AudioFormat arg0) throws LineUnavailableException {
		open(arg0,AudioSystem.NOT_SPECIFIED);
	}

	public void open(AudioFormat arg0, int arg1)
			throws LineUnavailableException {
		
		audioFormat=arg0;
		int frameSize=audioFormat.getFrameSize();
		if(arg1==AudioSystem.NOT_SPECIFIED){
			// four seconds
			bufferSize=(int)audioFormat.getSampleRate()*4*frameSize;
		}else{
			bufferSize=arg1;
		}
		bufferSize=(bufferSize /frameSize)*frameSize;
		
		// TODO ! TEST !!
		//bufferSize=705600;
		nativeDl=open(mixer.getMinfo().getNativeGUID(),audioFormat.getSampleRate(),audioFormat.getSampleSizeInBits(),audioFormat.getFrameSize(),audioFormat.getChannels(),bufferSize);
		if(DEBUG)System.out.println("open :"+DSMixerProvider.toHexString(nativeDl, true));
		super.open();
	}
	
	public void start(){
		nStart();
		super.start();
	}
	
	public native int available();
	
	public native int read(byte[] arg0, int arg1, int arg2);
	public void stop(){
		if (isActive()) {
			nStop();
			super.stop();
		}
	}
	public void close(){
		release();
		nativeDl=null;
		super.close();
	}
	
	public void drain(){
		// Do nothing 
		// Makes no sense for me to implement for capturing
	}
	public void finalize() throws Throwable{
		release();
		nativeDl=null;
		super.finalize();
	}
	public native long getLongFramePosition();

}
