package ips.audio.ds;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
public class DSSourceDataLine
	extends DSDataLine
	implements SourceDataLine {
	static final boolean DEBUG = false;
	
	private int bufferSize;
	
	public DSSourceDataLine(DSMixer m) {
		super(m);
	}

	private native byte[] open(byte[] devGuid,float samplesPerSec,int bitsPerSample,int frameSize,int channels,int bufferSize);
	public native void flush();
	public native void nStart();
	public native void nStop();
	public native int write(byte[] b, int off, int len);
	
	/* SourceDataLine interface */

	public void open(AudioFormat arg0) throws LineUnavailableException {
		open(arg0,AudioSystem.NOT_SPECIFIED);
	}

	public void open(AudioFormat arg0, int arg1)
			throws LineUnavailableException {
		
		audioFormat=arg0;
		int frameSize=audioFormat.getFrameSize();
		if(arg1==AudioSystem.NOT_SPECIFIED){
			// four seconds
			bufferSize=(int)audioFormat.getSampleRate()*4*frameSize;
		}else{
			bufferSize=arg1;
		}
		bufferSize=(bufferSize /frameSize)*frameSize;
		// TODO TEST !!
		//bufferSize=705600;
		nativeDl=open(mixer.getMinfo().getNativeGUID(),audioFormat.getSampleRate(),audioFormat.getSampleSizeInBits(),audioFormat.getFrameSize(),audioFormat.getChannels(),bufferSize);
		if(DEBUG)System.out.println("SDL open :"+DSMixerProvider.toHexString(nativeDl, true));
		super.open();
	}
	
	public void start(){
		nStart();
		super.start();
		if(DEBUG)System.out.println("SDL started.");
	}
	
	public void stop(){
		nStop();	
		super.stop();
		if(DEBUG)System.out.println("SDL stopped.");
	}
	
	public void close(){
		release();
		nativeDl=null;
		super.close();
	}

	public native int available();
	
	public void finalize() throws Throwable{
		release();
		nativeDl=null;
		super.finalize();
	}
	public native void drain();
	protected native void release(); 
	public synchronized native long getLongFramePosition();

}
