/*
 * Date  : Jul 1, 2011
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.audio.dsp;

import javax.sound.sampled.AudioFormat;

import org.junit.Assert;
import org.junit.Test;

import ipsk.audio.AudioFormatNotSupportedException;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class AudioSampleProcessorTest {

	public static double[] TEST_VALUES={0.125,0.009765625};
	
	public class AudioSampleProcessorImpl extends AudioSampleProcessor {
	}

	/**
	 * Test method for
	 * {@link ipsk.audio.dsp.AudioSampleProcessor#getDoubleValue(byte[],int)}.
	 * 
	 * @throws AudioFormatNotSupportedException
	 *
	 */
	@Test
	public void testLittleEndianConversion() throws AudioFormatNotSupportedException {
		AudioSampleProcessorImpl asp = new AudioSampleProcessorImpl();
		AudioFormat af1 = new AudioFormat(44100, 16, 1, true, false);
		asp.setAudioFormat(af1);
		byte[] sample1 = new byte[] { 0, 32, -128, 2, 0, -128 };
		// System.out.println(Integer.toBinaryString(new
		// Byte(sample1[2]).intValue()));
		double val1 = asp.getDoubleValue(sample1, 0);
		System.out.println("Little endian 1: " + val1);
		Assert.assertTrue(val1 == 0.125);
		double val2 = asp.getDoubleValue(sample1, 2);
		System.out.println("Little endian 2: " + val2);
		Assert.assertTrue(val2 == 0.009765625);

		double val3 = asp.getDoubleValue(sample1, 4);
		System.out.println("Little endian 3: " + val3);
		Assert.assertTrue(val3 == -0.5);
		
		
		float fval1 = asp.getFloatValue(sample1, 0);
		System.out.println("Float Little endian 1: " + fval1);
		Assert.assertTrue(fval1 == 0.125);
		float fval2 = asp.getFloatValue(sample1, 2);
		System.out.println("Float Little endian 2: " + fval2);
		Assert.assertTrue(fval2 == 0.009765625);

		float fval3 = asp.getFloatValue(sample1, 4);
		System.out.println("Float Little endian 3: " + fval3);
		Assert.assertTrue(fval3 == -0.5);

	}

	/**
	 * Test method for
	 * {@link ipsk.audio.dsp.AudioSampleProcessor#getDoubleValue(byte[],int)}.
	 * 
	 * @throws AudioFormatNotSupportedException
	 *
	 */
	@Test
	public void testBigEndianConversion() throws AudioFormatNotSupportedException {
		AudioSampleProcessorImpl asp = new AudioSampleProcessorImpl();
		AudioFormat af1 = new AudioFormat(44100, 16, 1, true, true);
		asp.setAudioFormat(af1);
		byte[] sample1 = new byte[] { 32, 0, 2, -128, -128, 0, -128, 0 };
		// System.out.println(Integer.toBinaryString(new
		// Byte(sample1[2]).intValue()));
		double val1 = asp.getDoubleValue(sample1, 0);
		System.out.println("Big endian 1: " + val1);
		Assert.assertTrue(val1 >= 0.125 && val1 < 0.126);
		double val2 = asp.getDoubleValue(sample1, 2);
		System.out.println("Big endian 2: " + val2);
		Assert.assertTrue(val2 == 0.009765625);
		double val3 = asp.getDoubleValue(sample1, 4);
		System.out.println("Big endian 3: " + val3);
		Assert.assertTrue(val3 == -0.5);
		double val4 = asp.getDoubleValue(sample1, 6);
		System.out.println("Big endian 4: " + val4);
		Assert.assertTrue(val4 == -0.5);
		
		float fval1 = asp.getFloatValue(sample1, 0);
		System.out.println("Float Big endian 1: " + fval1);
		Assert.assertTrue(fval1 == 0.125);
		float fval2 = asp.getFloatValue(sample1, 2);
		System.out.println("Float Big endian 2: " + fval2);
		Assert.assertTrue(fval2 == 0.009765625);
		float fval3 = asp.getFloatValue(sample1, 4);
		System.out.println("Float Big endian 3: " + fval3);
		Assert.assertTrue(fval3 == -0.5);

	}

	/**
	 * Test method for
	 * {@link ipsk.audio.dsp.AudioSampleProcessor#getDoubleValue(byte[],int)}.
	 * 
	 * @throws AudioFormatNotSupportedException
	 *
	 */
	@Test
	public void testLittleEndianUnsignedConversion() throws AudioFormatNotSupportedException {
		AudioSampleProcessorImpl asp = new AudioSampleProcessorImpl();
		AudioFormat af1 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100, 16, 1, 2, 44100, false);
		asp.setAudioFormat(af1);
		byte[] sample1 = new byte[] { 0, 32, -128, 2, 0, -128, -1, -1 };
		// System.out.println(Integer.toBinaryString(new
		// Byte(sample1[2]).intValue()));
		double val1 = asp.getDoubleValue(sample1, 0);
		System.out.println("Little endian unsigned 1: " + val1);
		Assert.assertTrue(val1 == 0.125);
		double val2 = asp.getDoubleValue(sample1, 2);
		System.out.println("Little endian unsigned 2: " + val2);
		Assert.assertTrue(val2 == 0.009765625);
		double val3 = asp.getDoubleValue(sample1, 4);
		System.out.println("Little endian unsigned 3: " + val3);
		Assert.assertTrue(val3 == 0.5);
		double val4 = asp.getDoubleValue(sample1, 6);
		System.out.println("Little endian unsigned 4: " + val4);
		Assert.assertTrue(val4 > 0.9999);
	}

	/**
	 * Test method for
	 * {@link ipsk.audio.dsp.AudioSampleProcessor#getDoubleValue(byte[],int)}.
	 * 
	 * @throws AudioFormatNotSupportedException
	 *
	 */
	@Test
	public void testBigEndianUnsignedConversion() throws AudioFormatNotSupportedException {
		AudioSampleProcessorImpl asp = new AudioSampleProcessorImpl();
		AudioFormat af1 = new AudioFormat(AudioFormat.Encoding.PCM_UNSIGNED, 44100, 16, 1, 2, 44100, true);

		asp.setAudioFormat(af1);
		byte[] sample1 = new byte[] { 32, 0, 2, -128, -128, 0 };
		// System.out.println(Integer.toBinaryString(new
		// Byte(sample1[2]).intValue()));
		double val1 = asp.getDoubleValue(sample1, 0);
		System.out.println("Big endian unsigned 1: " + val1);
		Assert.assertTrue(val1 >= 0.125 && val1 < 0.126);
		double val2 = asp.getDoubleValue(sample1, 2);
		System.out.println("Big endian unsigned 2: " + val2);
		Assert.assertTrue(val2 == 0.009765625);
		double val3 = asp.getDoubleValue(sample1, 4);
		System.out.println("Big endian unsigned 3: " + val3);
		Assert.assertTrue(val3 == 0.5);

	}
	
	/**
	 * Test method for
	 * {@link ipsk.audio.dsp.AudioSampleProcessor#encodeValue(double,byte[],int)}.
	 * 
	 * @throws AudioFormatNotSupportedException
	 *
	 */
	@Test
	public void testLittleEndianEncoding() throws AudioFormatNotSupportedException {
		AudioSampleProcessorImpl asp = new AudioSampleProcessorImpl();
		AudioFormat af1 = new AudioFormat(44100, 16, 1, true, false);
		asp.setAudioFormat(af1);
		byte[] sample1 = new byte[6];
		//{ 0, 32, -128, 2, 0, -128 };
		
		asp.encodeValue(0.125*2,sample1,0);
		System.out.println("Little endian enc 1: " + sample1[0]+" "+sample1[1]);
		Assert.assertTrue(sample1[0]==0 && sample1[1]==32);
		asp.encodeValue(0.009765625*2,sample1,2);
		System.out.println("Little endian enc 2: " + sample1[2]+" "+sample1[3]);
		Assert.assertTrue(sample1[2]==-128 && sample1[3]==2);

	}
	
	/**
	 * Test method for
	 * {@link ipsk.audio.dsp.AudioSampleProcessor#encodeValue(double,byte[],int)}.
	 * 
	 * @throws AudioFormatNotSupportedException
	 *
	 */
	@Test
	public void testBigEndianEncoding() throws AudioFormatNotSupportedException {
		AudioSampleProcessorImpl asp = new AudioSampleProcessorImpl();
		AudioFormat af1 = new AudioFormat(44100, 16, 1, true, true);
		asp.setAudioFormat(af1);
		byte[] sample1 = new byte[8];
		//{ 32, 0, 2, -128, -128, 0, -128, 0 };
		
		asp.encodeValue(0.125*2,sample1,0);
		System.out.println("Big endian enc 1: " + sample1[0]+" "+sample1[1]);
		Assert.assertTrue(sample1[0]==32 && sample1[1]==0);
		asp.encodeValue(0.009765625*2,sample1,2);
		System.out.println("Big endian enc 2: " + sample1[2]+" "+sample1[3]);
		Assert.assertTrue(sample1[2]==2 && sample1[3]==-128);

	}
	
	
	

}
