/*
 * Date  : Jan 11, 2012
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.media.jnm.impl.directshow;

import java.net.URL;

import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.ServiceDescriptor;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class NativeMediaDirectShowServiceDescriptor implements ServiceDescriptor{
    private URL packageURL;

    public LocalizableMessage getTitle() {
       return new LocalizableMessage("JNM DirectShow");
    }

    public LocalizableMessage getDescription() {
        return new LocalizableMessage("Java Native Media DirectShow Adapter.");
    }

    public String getVendor() {
        return "Institute of Phonetics and Speech processing, Munich";
    }

    public Version getSpecificationVersion() {
        
        return new Version(new int[]{0,0,1});
    }

    public Version getImplementationVersion() {
        return new Version(new int[]{0,0,1});
    }

    public Class<?> getServiceClass() {
       return ips.media.spi.NativeMediaSystem.class;
    }
    public String getServiceImplementationClassname() {
        return "de.klausj.video.impl.directshow.DSVideoSystem";
     }

 

    public URL getPackageURL() {
        return packageURL;
    }

    public void setPackageURL(URL packageURL) {
        this.packageURL = packageURL;
    }

 
    
}
