package ips.media.jnm.impl.directshow;


import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentLinkedQueue;

import ips.media.io.StreamSource;

public class AsyncReader implements  Runnable{
	
	
	private ConcurrentLinkedQueue<AsyncReadRequest> bufferFillRequests=new ConcurrentLinkedQueue<AsyncReadRequest>();

	private volatile AsyncReadRequest currentRequest=null;
	private Thread thread;
	private volatile boolean running;
	private volatile boolean flushing=false;
	private volatile boolean flushed=false;
	private StreamSource mediaStreamSource=null;
	

	public AsyncReader(){
		super();
		running=true;
//		thread=new Thread(this);
//		thread.start();
	}
		
	public long length() throws IOException{
		return mediaStreamSource.length();
	}
	
	public void open() throws IOException{
		if(mediaStreamSource!=null){
			mediaStreamSource.open();
		}
	}
	public void request(ByteBuffer nativeIMediaSample,long position,ByteBuffer bb,long requestID){
		//System.out.println("Request");
		AsyncReadRequest bfr=new AsyncReadRequest();
		bfr.pIMediaSample=nativeIMediaSample;
		bfr.position=position;
		bfr.buf=bb;
		bfr.dwUser=requestID;
		bufferFillRequests.add(bfr);
		
		
		synchronized(bufferFillRequests){
			bufferFillRequests.notifyAll();
		}
	}
	
	public void beginFlush(){
//		System.out.println("beginFlushJ AWT thread: "+EventQueue.isDispatchThread());
		
		synchronized(bufferFillRequests){
			int pending=bufferFillRequests.size();
			if(pending>0){
			System.out.println("Pending req: "+pending);
			}
			//bufferFillRequests.clear();
			flushing=true;
			bufferFillRequests.notifyAll();
//			while(!flushed){
//				try {
//					bufferFillRequests.wait(10);
//				} catch (InterruptedException e) {
//					// TODO Auto-generated catch block
//					e.printStackTrace();
//				}
//			}
		}
		//System.out.println("beginFlushJ out");
	}
	
	public void endFlush(){
		flushing=false;
	}
	
	public AsyncReadRequest waitForNext(long timeout){
		AsyncReadRequest bfr=null;
	do{
//		try {
//			Thread.sleep(500);
//		} catch (InterruptedException e1) {
//			// TODO Auto-generated catch block
//			e1.printStackTrace();
//		}
		synchronized(bufferFillRequests){
			bfr=bufferFillRequests.poll();
		}
		if(bfr!=null){
			
			ByteBuffer bb=bfr.buf;
			int bufSize=bb.capacity();
			byte[] buf=new byte[bufSize];
			try {
				//if(!flushing){
					int read=readForced(bfr.position,buf, 0, bufSize);
					bb.put(buf, 0, read);
				//}
				
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} 
			
		}else{
		synchronized (bufferFillRequests) {
			try {
				bufferFillRequests.wait(10000);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		}
	}while(bfr==null &&  ! (flushing && bufferFillRequests.size()==0));
	
	return bfr;
	}
//	public AsyncReadRequest waitForNext(long timeout){
//		System.out.println("wfn");
//		flushed=false;
//		synchronized(bufferFillRequests){
//			while(currentRequest==null){
//				try {
////					synchronized(bufferFillRequests){
//					bufferFillRequests.wait(1);
//					//}
//				} catch (InterruptedException e) {
//					// OK
//				}
//			}
//			AsyncReadRequest retReq;
////			synchronized(bufferFillRequests){
//				retReq=currentRequest;
//				currentRequest=null;
//				boolean isNull=(retReq==null);
//				System.out.println("wfn ret null:"+isNull);
//				flushed=true;
//				return retReq;
//			}
////			return retReq;
//		
//	}
	
//	public long 
	
	public int readSync(long pos,ByteBuffer buf,int len) throws IOException{
		mediaStreamSource.seek(pos);
		//byte[] bufArr=buf.array(); // does not work!
		byte[] bufArr=new byte[len];
		
		int r=mediaStreamSource.read(bufArr, 0, len);
		for(int i=0;i<len;i++){
			buf.put(bufArr[i]);
		}
		return r;
	}
	
	
	
	
	
	public int readSync(long pos,byte[] buf,int len) throws IOException{
		mediaStreamSource.seek(pos);
		
		int toRead=len;
		int r=0;
		int read=0;
		do{
			r=mediaStreamSource.read(buf, read, toRead);
			if(r>0){
				toRead-=r;
				read+=r;
			}
		}while(r!=-1 && toRead>0);
		return read;
	}
	
		
	public int readForced(long position,byte[] buf,int offset,int len) throws IOException{
		int toRead=len;
		int r=0;
		int read=0;
		mediaStreamSource.seek(position);
		do{
			
			r=mediaStreamSource.read(buf, offset+read, toRead);
			if(r>0){
				toRead-=r;
				read+=r;
			}
		}while(r!=-1 && toRead>0);
		//System.out.println("Read from "+position+" "+read+" bytes");
		return read;
	}
	
	public void run() {
		while(running){
			AsyncReadRequest bfr=null;
			synchronized(bufferFillRequests){
				bfr=bufferFillRequests.poll();
			}
			if(bfr!=null){
				
				ByteBuffer bb=bfr.buf;
				int bufSize=bb.capacity();
				byte[] buf=new byte[bufSize];
				try {
					
					int read=readForced(bfr.position,buf, 0, bufSize);
					bb.put(buf, 0, read);
					
					synchronized(bufferFillRequests){
						currentRequest=bfr;
						bufferFillRequests.notify();
						while(currentRequest!=null && ! flushing){
							bufferFillRequests.wait(1);
						}
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
			}else{
			synchronized (bufferFillRequests) {
				try {
					bufferFillRequests.wait(100);
				} catch (InterruptedException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			}
		}
	}
	
	
		
	
		public StreamSource getMediaStreamSource() {
			return mediaStreamSource;
		}
		
		public void setMediaStreamSource(StreamSource mediaStreamSource) {
			this.mediaStreamSource=mediaStreamSource;
		}
}
