package ips.media.jnm.impl.directshow;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;

import ips.media.MediaDecodingPlayer;
import ips.media.NativeMediaSystemException;
import ips.media.spi.NativeMediaSystem;
import ips.media.spi.VideoCaptureSourceInfo;
import ipsk.beans.dyn.DynProperty;
import ipsk.beans.dyn.DynPropertyDescriptor;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
//import javafx.stage.Window;

public class DSVideoSystem implements NativeMediaSystem{
	
	final static boolean DEBUG = false;
	
	final static int NATIVE_API_VERSION=33;
	
	static volatile boolean initialized=false;
	
	final static String NATIVE_LIB_NAME="JavaNativeMediaDirectShow";
	final static String DISPLAY_NAME="JNM DirectShow";
	final static String NATIVE_LIB_LOCATION_KEY="ips.jnm.directshow.nativelib";
	
	static {
		Throwable loadError=null;
		String nativeLibLocation=null;
		try{
			nativeLibLocation=System.getProperty(NATIVE_LIB_LOCATION_KEY);	
		}catch(SecurityException se){
			//OK no debug mode, continue
		}
		
		if (nativeLibLocation!=null){
			if(DEBUG)System.out.println(DISPLAY_NAME+" library loading ... ");
			File dsLib=new File(nativeLibLocation);
			if(!dsLib.exists()){
				System.err.println(DISPLAY_NAME+" library not found!");
			}
			try{
				System.load(nativeLibLocation);
			}catch(UnsatisfiedLinkError ule){
				System.err.println(ule);
			}
			
		}else{
			if(DEBUG){
				System.out.println("Loading native lib "+NATIVE_LIB_NAME+" from: "+System.getProperty("java.library.path"));
			} 
			try{
                System.loadLibrary("mfc120u");
                if(DEBUG)System.out.println("Loaded library mfc120u (default amd64)");
            }catch(Error e1){
                try{
                    System.loadLibrary("mfc120u_amd64");
                    if(DEBUG)System.out.println("Loaded library mfc120u_amd64");
                }catch(Error e2){
                    try{
                        System.loadLibrary("mfc120u_x86");
                        if(DEBUG)System.out.println("Loaded library mfc120u_x86");
                    }catch(Error e3){
                        System.err.println(e3);
                    }
                }
            }
			try{
				System.loadLibrary(NATIVE_LIB_NAME);
				if(DEBUG)System.out.println("Loaded library "+NATIVE_LIB_NAME+" (default amd64)");
			}catch(Error e1){
			    try{
			        System.loadLibrary(NATIVE_LIB_NAME+"_amd64");
			        if(DEBUG)System.out.println("Loaded library "+NATIVE_LIB_NAME+"_amd64)");
			    }catch(Error e2){
			        try{
			            System.loadLibrary(NATIVE_LIB_NAME+"_x86");
			            
			            if(DEBUG)System.out.println("Loaded library "+NATIVE_LIB_NAME+"_x86");
			        }catch(Error e3){
			            System.err.println(e3);
			        }
			    }
			}
		}
		if (DEBUG){
			if(loadError==null){
				System.out.println(DISPLAY_NAME+" driver loaded");
			}
		}
		
	}
	private ByteBuffer nativePointer;
	
	public DSVideoSystem(){
		super();
		
		//enumerateVideoCaptureSources();
	}
	
	//@Override
	public synchronized void initialize() throws NativeMediaSystemException {
		if(initialized){
			return;
		}
		int nativeApiVers=init();
		if(nativeApiVers!=NATIVE_API_VERSION){
			String eMsg="Cannot initiliaze JNM DirectShow: Native API version "+nativeApiVers+" differs from Java API version "+NATIVE_API_VERSION;
			System.err.println(eMsg);
			throw new NativeMediaSystemException(eMsg);
		}
		initialized=true;
	}
	public static native int init() throws NativeMediaSystemException;
//	public static native long nativeJFXWindowHwn(Window window);
	public static native void enumerateVideoCaptureSources();
	
	public static DSMediaDecodingPlayer createDirectShowMediaDecodingPlayer(){
		return new DSMediaDecodingPlayer();
	}
	
	public static native void release() throws NativeMediaSystemException;
	
	
//	public static void main(String[] args){
//		try {
//			init();
//		} catch (VideoSystemException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		DSMediaDecodingPlayer dsmdp=createDirectShowMediaDecodingPlayer();
//		JVideoComponent jvc=new JVideoComponent();
//		dsmdp.addVideoTrackListener(jvc);
//		jvc.setPreferredSize(new Dimension(500,500));
//		JFrame f=new JFrame();
//		f.getContentPane().setLayout(new BorderLayout());
//		
//		f.getContentPane().add(jvc,BorderLayout.CENTER);
//		JPlayerControl pc=new JPlayerControl(dsmdp);
//		f.getContentPane().add(pc,BorderLayout.SOUTH);
//		
//		f.pack();
//		f.setVisible(true);
//		
//		File mediaFile=new File(args[0]);
////		dsmdp.setMediaStreamSource(new FileStreamSource(mediaFile));
//		dsmdp.setNativeMediaFile(mediaFile);
//		try {
//			dsmdp.open();
//		} catch (VideoSystemException e) {
//			// TODO Auto-generated catch block
//			e.printStackTrace();
//		}
//		//dsmdp.renderTestJ();
//		
//	}

	
	public LocalizableMessage getTitle() {
		
		return new LocalizableMessage("DirectShow");
	}

	
	public LocalizableMessage getDescription() {
		return null;
	}

	
	public String getVendor() {
		// TODO Auto-generated method stub
		return null;
	}

	public Version getSpecificationVersion() {
		
		return null;
	}

	public Version getImplementationVersion() {
		
		return new Version(new int[]{0,0,1});
	}

	public List<DynPropertyDescriptor> getDynamicPropertyDescriptors() {
		
		return null;
	}

	public void setDynamicProperty(DynProperty dynProperty) {
		
	}

	public DynProperty getDynamicProperty(String name) {
		
		return null;
	}

	public MediaDecodingPlayer createMediaDecodingPlayer() {
		return new DSMediaDecodingPlayer();
	}
	
	public List<VideoCaptureSourceInfo> getVideoCaptureSourceInfos() {
		return null;
	}

    //@Override
    public boolean supportsMediaDecodingPlayer() {
        return true;
    }

    //@Override
    public boolean supportsVideoCapture() {
        return false;
    }

  
	
	
}
