/*
 * Date  : Jan 11, 2012
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.prompting.media;

import java.net.URL;

import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class NativeMediaPromptPresenterServiceDescriptor implements PromptPresenterServiceDescriptor{
    private URL packageURL;

    public LocalizableMessage getTitle() {
       return new LocalizableMessage("Native media prompt presenter");
    }

    public LocalizableMessage getDescription() {
        return new LocalizableMessage("Prompts media (videos) using native multimedia system of operating system.");
    }

    public String getVendor() {
        return "Institute of Phonetics and Speech processing, Munich";
    }

    public Version getSpecificationVersion() {
        
        return new Version(new int[]{0,2,0});
    }

    public Version getImplementationVersion() {
        return new Version(new int[]{0,1,2});
    }

    public Class<?> getServiceClass() {
       return ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter.class;
    }
    public String getServiceImplementationClassname() {
        return "ips.prompting.media.NativeMediaPromptPresenter";
     }

    public String[][] getSupportedMIMETypes() {
        String[] mType1=new String[]{"video/mpeg"};
        String[] mType2=new String[]{"video/x-msvideo"};
        return new String[][]{mType1,mType2};	
    }

    public URL getPackageURL() {
        return packageURL;
    }

    public void setPackageURL(URL packageURL) {
        this.packageURL = packageURL;
    }

 
    
}
