package ips.media.video;

import java.awt.AWTException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.ImageCapabilities;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Transparency;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.VolatileImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;

public class JVideoFrameConverter {

	public JVideoFrameConverter() {
		// TODO Auto-generated constructor stub
	}

	
	private volatile BufferedImage currentFrame;
	private VideoFormat videoFormat;
	
	private boolean keepAspectRatio = true;
	private RenderingHints rh;
	private BufferedImageOp scaleOp;
	private double scaleX;
	private double scaleY;

	private volatile VolatileImage bufImg;
	private Image sImg;
	
	private PixelInterleavedSampleModel csm;
	private volatile DataBuffer dataBuf;
	private ComponentColorModel ccm;
	private volatile WritableRaster wr;
	private byte[] convImgData;
	
	public boolean isKeepAspectRatio() {
		return keepAspectRatio;
	}

	public void setKeepAspectRatio(boolean keepAspectRatio) {
		this.keepAspectRatio = keepAspectRatio;
	}



	//@Override
	public void setVideoFormat(VideoFormat videoFormat) {
		this.videoFormat = videoFormat;
		if (videoFormat != null) {

			Dimension imgSize = videoFormat.getSize();
			
			Dimension par = videoFormat.getPixelAspectRatio();
			
		
		
//		ImageCapabilities ic = new ImageCapabilities(true);
//		int[] bandOffsets;
//		int bytes=3;
//		int bits=videoFormat.
//		if(bits==24){
//			bytes=3;
//			bandOffsets=new int[]{2,1,0};
//		}else if(bits==32){
//			bytes=4;
//			bandOffsets=new int[]{2,1,0,3};
//		}else{
//			return null;
//		}
		
		int[] rgbOffsets=videoFormat.getRgbOffsets();
		// Ogg format does not use JVideoRenderer if we do not enable RGB_32 (without alpha)
		
		int trgPixelStride=rgbOffsets.length;
		int bytes=videoFormat.getPixelStride();
		int imgBufsize=imgSize.width* imgSize.height * trgPixelStride;
		
		csm = new PixelInterleavedSampleModel(
				DataBuffer.TYPE_BYTE, imgSize.width, imgSize.height, trgPixelStride,
				imgSize.width * trgPixelStride, rgbOffsets);
		convImgData = new byte[imgBufsize];
		dataBuf = new DataBufferByte(convImgData, imgSize.width
				* imgSize.height * trgPixelStride);
		boolean hasAlpha=videoFormat.isHasAlpha();
		
		ccm = new ComponentColorModel(
				ColorSpace.getInstance(ColorSpace.CS_sRGB),
				// ColorSpace.getInstance(ColorSpace.CS_LINEAR_RGB),
				hasAlpha, false, Transparency.TRANSLUCENT, DataBuffer.TYPE_BYTE);
		wr = Raster.createWritableRaster(csm, dataBuf,
				new Point(0, 0));
		currentFrame = new BufferedImage(ccm, wr, false, null);
		
	
		}
		
	}
	
	
	
	
	public BufferedImage convert(byte[] frameData){
		int[] rgbOffsets=videoFormat.getRgbOffsets();
		int trgPixelStride=rgbOffsets.length;
		int srcPixelStride=videoFormat.getPixelStride();
		int width=videoFormat.getSize().width;
		int height=videoFormat.getSize().height;
		int srcLineStride=width*srcPixelStride;
		int lineStride=width*rgbOffsets.length;
		
		if(srcPixelStride!=trgPixelStride){
			// for example DirectShow RGB 32
			int srcPos;
			int dstPos=0;
			int j=0;
			if(videoFormat.isLinesBottomUp()){
				for(int lc=0;lc<height;lc++){
					srcPos=(height-lc-1)*srcLineStride;

					for(int i=0;i<srcLineStride;i+=srcPixelStride){
						for(int os=0;os<trgPixelStride;os++){
						convImgData[j++]=frameData[srcPos+i+os];
						}
					}
					//					dstPos+=lineStride;
				}
			}else{
				for(int i=0;i<frameData.length;i+=srcPixelStride){
					for(int os=0;os<trgPixelStride;os++){
						convImgData[j++]=frameData[i+os];
					}
				}
			}
		}else if(videoFormat.isLinesBottomUp()){

			// turn upside down

			int srcPos;
			int dstPos=0;

			for(int lc=0;lc<height;lc++){
				srcPos=(height-lc-1)*lineStride;
				System.arraycopy(frameData, srcPos, convImgData, dstPos, lineStride);
				dstPos+=lineStride;
			}
		}else{
			//currentFrame.setData(wr);
			System.arraycopy(frameData,0, convImgData,0, frameData.length);
		}

		return currentFrame;
	}

	
}


	
	

