package ips.media;

import java.awt.Component;
import java.io.File;

import javax.sound.sampled.Mixer;
import ips.media.control.MediaControlListener;
import ips.media.io.StreamSource;
import ips.media.video.NativeWindowHandle;
import ips.media.video.VideoTrackListener;

public interface MediaDecodingPlayer extends MediaPipeline{

    public void addMediaControlListener(MediaControlListener mediaControlListener);
    public void removeMediaControlListener(MediaControlListener mediaControlListener);
    public void addVideoTrackListener(VideoTrackListener videoTrackListener);
  
    public boolean isNativeVideoComponentRenderingSupported();
    public boolean isJavaSoundSupported();
    
    public void setAWTVideoComponent(Component heavyWeightComponent) throws NativeMediaSystemException;
    public void setVideoComponentNativeWindowHandle(NativeWindowHandle nativeWindowHandle) throws NativeMediaSystemException;
    public boolean requiresDisplayableToRun();
    public void setNativeVideoCanvasSize(double width,double height);
    public void setUseJavaSound(boolean useJavaSound);
    public void setSilent(boolean silent);
    public void setAudioDeviceInfo(Mixer.Info audioDeviceInfo);
   
    public StreamSource getMediaStreamSource();
    public boolean isMediaStreamSourceSupported();
    public void setMediaStreamSource(StreamSource mediaStreamSource);
    public void setNativeMediaFile(File mediaFile);
    public void rewind();
    public long getPositionNs();
//    public void stepForward();

}
