package ips.media.app.player;

import ipsk.swing.CloseAction;
import ipsk.swing.ExitAction;
import ipsk.swing.JMultiSplitPane;
import ipsk.swing.OpenAction;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

import ips.media.MediaDecodingPlayer;
import ips.media.NativeMediaResult;
import ips.media.NativeMediaSystemException;
import ips.media.NativeMediaSystemsManager;
import ips.media.control.MediaControlListener;
import ips.media.event.MediaCloseEvent;
import ips.media.event.MediaDurationAvailableEvent;
import ips.media.event.MediaErrorEvent;
import ips.media.event.MediaEvent;
import ips.media.event.MediaOpenEvent;
import ips.media.spi.NativeMediaSystem;
import ips.media.ui.JPlayerControl;
import ips.media.video.AWTVideoComponent;
import ips.media.video.JVideoComponent;
import ips.media.video.JVideoPanel;
import ips.media.video.VideoTrackListener;

public class JMediaPlayer extends JFrame implements WindowListener, MediaControlListener {
    
	private final static boolean DEBUG=false;
	private final static boolean USE_SWING=false;
	private final static boolean USE_NATIVE_AWT=true;
	private final static boolean USE_JAVASOUND=true;
	public class FileOpenAction extends OpenAction {

		private Component parent;

		public FileOpenAction(Component parent) {
			super();
			this.parent = parent;
		}

		@Override
		public void actionPerformed(ActionEvent e) {
			JFileChooser jfc = new JFileChooser();
			int res = jfc.showOpenDialog(parent);
			if (res == JFileChooser.APPROVE_OPTION) {
				File mediaFile = jfc.getSelectedFile();
				close();
				mediaDecodingPlayer.setNativeMediaFile(mediaFile);
				open();
			}
		}
	}
	public class FileCloseAction extends CloseAction {
		@Override
		public void actionPerformed(ActionEvent e) {
				close();
		}
	}
	
	public class PExitAction extends ExitAction {
		@Override
		public void actionPerformed(ActionEvent e) {
				exit();
		}

		
	}
	private JMenuBar mainMenuBar = new JMenuBar();

	private JMenu fileMenu = new JMenu("File");

	private JMenuItem miOpen;

	private JMenuItem miClose;
	
	private JMenuItem miExit;

	private MediaDecodingPlayer mediaDecodingPlayer;

	private VideoTrackListener vtl;
//	private JVideoComponent videoComponent;
	private Component vc;
	private FileCloseAction fileCloseAction;
    private JMultiSplitPane msp;

	public void setNativeMediaFile(File mediaFile) {
		mediaDecodingPlayer.setNativeMediaFile(mediaFile);
	}

	public void exit() {
		close();
		dispose();
		System.exit(0);
	}

	public JMediaPlayer() throws NativeMediaSystemException {
		super();
		init();
		if(USE_SWING){
		    JVideoComponent videoComponent = new JVideoComponent();
		    vtl=videoComponent;
		    vc=videoComponent;
		}else{
		    JVideoPanel vp=new JVideoPanel();
		    vc=vp;
            vtl=vp;
		    if(USE_NATIVE_AWT && mediaDecodingPlayer.isNativeVideoComponentRenderingSupported()){
                mediaDecodingPlayer.setAWTVideoComponent(vp.getAwtVideoComponent());
            }
		}
		mediaDecodingPlayer.setUseJavaSound(USE_JAVASOUND && mediaDecodingPlayer.isJavaSoundSupported());
		mediaDecodingPlayer.addMediaControlListener(this);
		if(vtl!=null){
		    mediaDecodingPlayer.addVideoTrackListener(vtl);
		}
		vc.setPreferredSize(new Dimension(500, 500));
		FileOpenAction fileOpenAction=new FileOpenAction(this);
		fileCloseAction = new FileCloseAction();
		fileCloseAction.setEnabled(false);
		PExitAction pea=new PExitAction();
		miOpen=new JMenuItem(fileOpenAction);
		fileMenu=new JMenu("File");
		fileMenu.add(miOpen);
		miClose=new JMenuItem(fileCloseAction);
		fileMenu.add(miClose);
		miExit=new JMenuItem(pea);
		fileMenu.add(miExit);
		mainMenuBar.add(fileMenu);
		setJMenuBar(mainMenuBar);
		getContentPane().removeAll();
		getContentPane().setLayout(new BorderLayout());
		JPanel vP=new JPanel();
		vP.setLayout(new BorderLayout());
		JButton jb=new JButton("T");
		vP.add(jb,BorderLayout.WEST);
		vP.add(vc,BorderLayout.CENTER);
		msp = new JMultiSplitPane();
		
//		vc.setPreferredSize(new Dimension(200,100));
//		vc.setMinimumSize(new Dimension(200,100));
//		msp.add(vc);
//		msp.add(new JButton("Bla2"));
//		JSplitPane sp=new JSplitPane(JSplitPane.VERTICAL_SPLIT, vc, new JButton("bla"));
//		msp.moveToBack(vc);
		//getContentPane().setIgnoreRepaint(true);
		getContentPane().add(vc, BorderLayout.CENTER);

		JPlayerControl pc = new JPlayerControl(mediaDecodingPlayer);
		getContentPane().add(pc, BorderLayout.SOUTH);
		setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
		addWindowListener(this);

	}

	public void open() {
		vc.setEnabled(true);
		try {
			NativeMediaResult res=mediaDecodingPlayer.open();
			if(NativeMediaResult.Type.ERROR.equals(res.getType())){
				throw new NativeMediaSystemException(res.getMessage());
			}else if(NativeMediaResult.Type.WARNING.equals(res.getType())){
				JOptionPane.showMessageDialog(this, res.getMessage(), "Media player open warning", JOptionPane.WARNING_MESSAGE);
			}
			fileCloseAction.setEnabled(true);
		} catch (NativeMediaSystemException e) {
			vc.setEnabled(false);
			e.printStackTrace();
			JOptionPane.showMessageDialog(this, e.getMessage(), "Media player open error", JOptionPane.ERROR_MESSAGE);
		}
	}
	
	public void close() {
		mediaDecodingPlayer.close();
		mediaDecodingPlayer.setNativeMediaFile(null);
//		videoComponent.setEnabled(false);
//		videoComponent.clear();
//		fileCloseAction.setEnabled(false);
	}

	public void init() throws NativeMediaSystemException {
		NativeMediaSystem nms = NativeMediaSystemsManager
				.createDefaultNativeMediaSystem();
		if (nms == null) {
			System.err.println("Could not instantiate native media system.");
			System.exit(-1);
		}else{
			nms.initialize();
		}
		
		if(DEBUG)System.out.println("Using native media system: "
				+ nms.getTitle().localize());
		mediaDecodingPlayer = nms.createMediaDecodingPlayer();
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
	    final File mediaFile;
	    if (args.length > 0) {
            mediaFile = new File(args[0]);
	    }else{
	        mediaFile=null;
	    }
	    Runnable guiRun=new Runnable() {
            
            @Override
            public void run() {
                JMediaPlayer p;
                try {
                    p = new JMediaPlayer();

                    p.pack();
                    p.setVisible(true);
                   if(mediaFile!=null){
                        p.setNativeMediaFile(mediaFile);
                        p.open();
                   }
                 
                } catch (NativeMediaSystemException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }

                
            }
        };
		SwingUtilities.invokeLater(guiRun);
	}

	public void windowOpened(WindowEvent e) {

	}

	public void windowIconified(WindowEvent e) {
	

	}

	public void windowDeiconified(WindowEvent e) {
	

	}

	public void windowDeactivated(WindowEvent e) {
		

	}

	public void windowClosing(WindowEvent e) {
	    exit();
	}

	public void windowClosed(WindowEvent e) {
//		exit();
	}

	public void windowActivated(WindowEvent e) {
	
	}

	public void update(MediaEvent mediaEvent) {
		if(mediaEvent instanceof MediaOpenEvent){
			fileCloseAction.setEnabled(true);
			// does not work open event in JPlayerControl comes after stop event
			// therefore the step button is disabled
//			mediaDecodingPlayer.stop();
		}else if(mediaEvent instanceof MediaCloseEvent){
			vc.setEnabled(false);
//			vc.clear();
			fileCloseAction.setEnabled(false);
		}else if(mediaEvent instanceof MediaErrorEvent){
			MediaErrorEvent mee=(MediaErrorEvent)mediaEvent;
			String msg="Media error";
			Exception e=mee.getException();
			if(e!=null){
				String meeMsg=e.getMessage();
				if(meeMsg!=null){
					msg=meeMsg;
				}
			}
			JOptionPane.showMessageDialog(this,msg, "Media error", JOptionPane.ERROR_MESSAGE);
		}
	}

}
