package ipsk.db.speech.speaker;

import ipsk.beans.PropertyValidationResult;
import ipsk.beans.PropertyValidationResult.Type;
import ipsk.beans.validation.ValidationResult;
import ipsk.db.speech.Speaker;
import ipsk.util.LocalizableMessage;

public class SpeakerValidator {

	public static void validateSpeakerCode(ValidationResult vr,String spkCode) {

		if(spkCode !=null) {
			if(!spkCode.isEmpty()) {

				if(!spkCode.matches("^[\\w-:! \\.]*$")) {
					vr.setType(ValidationResult.Type.ERRORS);
					var msg=new LocalizableMessage("Illegal character(s) in speaker code. Allowed are alphanumeric ASCII characters and - and _");
					PropertyValidationResult namePropVr=new PropertyValidationResult(Type.ERROR,msg);
					vr.putPropertyValidationResult("code", namePropVr);
					//vr.setPropertyValidationResults(propVrMap);
				}
				if(spkCode.matches(".*\\.{2,}?.*")) {
					vr.setType(ValidationResult.Type.ERRORS);
					var msg=new LocalizableMessage("Speaker code must not contain dot sequences");
					PropertyValidationResult namePropVr=new PropertyValidationResult(Type.ERROR,msg);
					vr.putPropertyValidationResult("code", namePropVr);
					//vr.setPropertyValidationResults(propVrMap);
				}
				if(spkCode.matches("^\\s+.*")) {
					vr.setType(ValidationResult.Type.ERRORS);
					var msg=new LocalizableMessage("Speaker code must not start with blank characters");
					PropertyValidationResult namePropVr=new PropertyValidationResult(Type.ERROR,msg);
					vr.putPropertyValidationResult("code", namePropVr);
					//vr.setPropertyValidationResults(propVrMap);
				}
				if(spkCode.matches(".*\\s+$")) {
					vr.setType(ValidationResult.Type.ERRORS);
					var msg=new LocalizableMessage("Speaker code must not end with blank characters");
					PropertyValidationResult namePropVr=new PropertyValidationResult(Type.ERROR,msg);
					vr.putPropertyValidationResult("code", namePropVr);
					//vr.setPropertyValidationResults(propVrMap);
				}
			}
		}
	}
	
	
	public static ValidationResult validateSpeaker(Speaker speaker) {
		var vr=new ValidationResult();
		SpeakerValidator.validateSpeakerCode(vr,speaker.getCode());
		return  vr;
	}

}
