package ipsk.db.speech.project;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.xml.bind.annotation.XmlTransient;

import ipsk.db.speech.ConditionalClientConfig;
import ipsk.db.speech.Project;
import ipsk.db.speech.project.MediaStreamConstraints.ConstraintType;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

@Entity
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("config.auto_gain_control")
public class AutoGainControlConfig extends ConditionalClientConfig {

	private int id;
	
	private Project project;
	
	@Id
	@Column(name = "id", unique = true, nullable = false)
    @GeneratedValue(generator="id_gen")
    @ResourceKey("id")
    public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}
	
	@ManyToOne
	@ResourceKey("project")
	@XmlTransient
	public Project getProject() {
		return project;
	}
	public void setProject(Project project) {
		this.project = project;
	}

	private boolean value;

	@ResourceKey("value")
	public boolean getValue() {
		return value;
	}

	public void setValue(boolean value) {
		this.value = value;
	}
	
//	private ConstraintType constraintType=ConstraintType.EXACT;
//
//	@Enumerated(EnumType.STRING)
//	public ConstraintType getConstraintType() {
//		return constraintType;
//	}
//
//	public void setConstraintType(ConstraintType constraintType) {
//		this.constraintType = constraintType;
//	}
	
}
