package ipsk.db.speech.project;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlTransient;

import ipsk.beans.PreferredDisplayOrder;
import ipsk.db.speech.Project;
import ipsk.util.ResourceBundleName;
import ipsk.util.ResourceKey;

/**
 * Media storage format.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */
@Entity
@Table(name = "media_storage_format", schema = "public")
@ResourceBundleName("ipsk.db.speech.PropertyNames")
@ResourceKey("media.storage.format")
@PreferredDisplayOrder("audioEncoding,audioPCMSampleSizeInBits")
public class MediaStorageFormat {

	public enum AudioEncoding {PCM_SIGNED,PCM_FLOAT};
	
	private String name;
	
	@Id
	@Column(nullable = false)
    @ResourceKey("name")
    @XmlTransient
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name= name;
	}

	private Project project;
	
	@MapsId
	@OneToOne
	@JoinColumn(name = "name")
	@XmlTransient
	public Project getProject() {
		return project;
	}

	public void setProject(Project project) {
		this.project = project;
	}

	
	private AudioEncoding audioEncoding=AudioEncoding.PCM_SIGNED;
	
	@ResourceKey("audio.format.encoding")
	@Enumerated(EnumType.STRING)
	public AudioEncoding getAudioEncoding() {
		return audioEncoding;
	}

	public void setAudioEncoding(AudioEncoding encoding) {
		this.audioEncoding = encoding;
	}
	
	@ResourceKey("quantisation")
	public Integer getAudioPCMSampleSizeInBits() {
		return audioPCMSampleSizeInBits;
	}

	public void setAudioPCMSampleSizeInBits(Integer sampleSizeInBits) {
		this.audioPCMSampleSizeInBits = sampleSizeInBits;
	}

	private Integer audioPCMSampleSizeInBits=null;
	
	public MediaStorageFormat() {
		super();
		
	}
	
	public String toString() {
		String audioDescr;
		if(audioEncoding!=null) {
			audioDescr=audioEncoding.toString(); 
		}else {
			audioDescr="(Default encoding)";
		}
		if(!AudioEncoding.PCM_FLOAT.equals(audioEncoding) && audioPCMSampleSizeInBits!=null) {
			audioDescr=audioDescr+", "+audioPCMSampleSizeInBits+" bits";
		}
		return "Audio: "+audioDescr;
	}


}
