/*
 * Date  : 11.01.2015
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.db.speech.script;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import javax.persistence.Transient;

import org.w3c.dom.Document;

import ipsk.xml.DOMConverter;
import ipsk.xml.DOMConverterException;


/**
 * Transferable list of script groups.
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 * 
 */
public class PromptGroupsList extends ArrayList<Group> implements Transferable {
	public static final DataFlavor CLASS_DATA_FLAVOR = new DataFlavor(
			PromptGroupsList.class, null);
	
	private transient DataFlavor textXmlFlavor;
	private transient DataFlavor[] dataFlavors;
	private transient DOMConverter domConverter;

	public PromptGroupsList(){
		super();
		textXmlFlavor=DataFlavor.stringFlavor;
		if(textXmlFlavor!=null){
			dataFlavors=new DataFlavor[]{CLASS_DATA_FLAVOR,textXmlFlavor};
		}else{
			dataFlavors=new DataFlavor[]{CLASS_DATA_FLAVOR};
		}
	}
	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * java.awt.datatransfer.Transferable#getTransferData(java.awt.datatransfer
	 * .DataFlavor)
	 */
	@Override
	public Object getTransferData(DataFlavor flavor)
			throws UnsupportedFlavorException, IOException {

		if (!isDataFlavorSupported(flavor)) {
			throw new UnsupportedFlavorException(flavor);
		}
		if(CLASS_DATA_FLAVOR.equals(flavor)){
			return this;
		}else if(textXmlFlavor!=null && textXmlFlavor.equals(flavor)){

			try {

				if(domConverter==null){
					domConverter = new DOMConverter();
				}
				StringBuffer sb=new StringBuffer();
				for(Group g:this){
					Document d=domConverter.newDocument();
					d.appendChild(g.toElement(d));
					String puStr=domConverter.writeFragmentToString(d);
					sb.append(puStr);
				}
				return sb.toString();
			} catch (DOMConverterException e) {
				throw new IOException(e);
			}

		}else{
			throw new UnsupportedFlavorException(flavor);
		}
	}


	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.datatransfer.Transferable#getTransferDataFlavors()
	 */
	@Override
	public DataFlavor[] getTransferDataFlavors() {
		return dataFlavors;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.awt.datatransfer.Transferable#isDataFlavorSupported(java.awt.
	 * datatransfer.DataFlavor)
	 */
	@Override
	public boolean isDataFlavorSupported(DataFlavor flavor) {
		for(DataFlavor df:dataFlavors){
			if(df.equals(flavor)){
				return true;
			}
		}
		return false;
	}

}
