package ips.annot.model.emu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import ips.annot.model.db.LevelDefinition;
import ips.annot.model.db.LinkDefinition;
import ips.annot.model.emu.webapp.EMUwebAppConfig;

@XmlType( propOrder = {
        "name",
        "uuid",
        "mediafileExtension",
        "ssffTrackDefinitions",
        "levelDefinitions",
        "linkDefinitions",
        "EMUwebAppConfig"})
public class EmuDB {
    
    private String name;
    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private UUID uuid;
    @XmlElement(name="UUID")
    public UUID getUuid() {
        return uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    private String mediafileExtension="wav";

    public String getMediafileExtension() {
        return mediafileExtension;
    }

    public void setMediafileExtension(String mediafileExtension) {
        this.mediafileExtension = mediafileExtension;
    }

    List<SSFFTrackDefinition> ssffTrackDefinitions=new ArrayList<SSFFTrackDefinition>();
//    "type": "array",
//    "items": {
//        "type": "object",
//        "properties": {
//            "columnName": {
//                "type": "string"
//            },
//            "fileExtension": {
//                "type": "string"
//            },
//            "name": {
//                "type": "string"
//            }
//        },
//        "required": ["name", "columnName", "fileExtension"],
//        "additionalProperties": false
//    }

    public List<SSFFTrackDefinition> getSsffTrackDefinitions() {
        return ssffTrackDefinitions;
    }

    public void setSsffTrackDefinitions(List<SSFFTrackDefinition> ssffTrackDefinitions) {
        this.ssffTrackDefinitions = ssffTrackDefinitions;
    }

    List<LevelDefinition> levelDefinitions=new ArrayList<LevelDefinition>();
    
//    "type": "array",
//    "items": {
//        "type": "object",
//        "properties": {
//            "name": {
//                "type": "string"
//            },
//            "type": {
//                "enum": ["ITEM", "SEGMENT", "EVENT"]
//            },
//            "attributeDefinitions": {
//                "type": "array",
//                "items": {
//                    "type": "object",
//                    "properties": {
//                        "name": {
//                            "type": "string"
//                        },
//                        "type": {
//                            "enum": ["STRING"]
//                        },
//                        "description": {
//                            "type": "string"
//                        },
//                        "legalLabels": {
//                            "type": "array",
//                            "items": {
//                                "type": "string"
//                            }
//                        },
//                        "labelGroups": {
//                            "type": "array",
//                            "items": {
//                                "type": "object",
//                                "properties": {
//                                    "name": {
//                                        "type": "string"
//                                    },
//                                    "values": {
//                                        "type": "array",
//                                        "items": {
//                                            "type": "string"
//                                        }
//                                    }
//                                },
//                                "required": ["name", "values"],
//                                "additionalProperties": false
//                            }
//                        }
//                    },
//                    "required": ["name", "type"],
//                    "additionalProperties": false
//                }
//            },
//            "anagestConfig": {
//                "type": "object",
//                "properties": {
//                    "verticalPosSsffTrackName": {
//                        "type": "string"
//                    },
//                    "velocitySsffTrackName": {
//                        "type": "string"
//                    },
//                    "autoLinkLevelName": {
//                        "type": "string"
//                    },
//                    "gestureDirection": {
//                        "enum": ["peak", "valley"]
//                    },
//                    "threshold": {
//                        "type": "number",
//                        "minimun": "0.0",
//                        "maximum": "1.0"
//                    },
//                    "gestureOnOffsetLabels": {
//                        "type": "array",
//                        "items": {
//                            "type": "string"
//                        },
//                        "minItems": 2,
//                        "maxItems": 2
//                    },
//                    "maxVelocityOnOffsetLabels": {
//                        "type": "array",
//                        "items": {
//                            "type": "string"
//                        },
//                        "minItems": 2,
//                        "maxItems": 2
//                    },
//                    "constrictionPlateauBeginEndLabels": {
//                        "type": "array",
//                        "items": {
//                            "type": "string"
//                        },
//                        "minItems": 2,
//                        "maxItems": 2
//                    },
//                    "maxConstrictionLabel": {
//                        "type": "string"
//                    }
//                },
//                "required": ["verticalPosSsffTrackName", "velocitySsffTrackName", "autoLinkLevelName", "gestureDirection", "threshold", "gestureOnOffsetLabels", "maxVelocityOnOffsetLabels", "constrictionPlateauBeginEndLabels", "maxConstrictionLabel"],
//                "additionalProperties": false,
//                "uniqueItems": true
//            }
//        },
//        "required": ["name", "type", "attributeDefinitions"],
//        "additionalProperties": false,
//        "uniqueItems": true
//    }


    public List<LevelDefinition> getLevelDefinitions() {
        return levelDefinitions;
    }

    public void setLevelDefinitions(List<LevelDefinition> levelDefinitions) {
        this.levelDefinitions = levelDefinitions;
    }

    private List<LinkDefinition> linkDefinitions=new ArrayList<LinkDefinition>();
public List<LinkDefinition> getLinkDefinitions() {
        return linkDefinitions;
    }

    public void setLinkDefinitions(List<LinkDefinition> linkDefinitions) {
        this.linkDefinitions = linkDefinitions;
    }

//    "type": "array",
//    "items": {
//        "type": "object",
//        "properties": {
//            "type": {
//                "enum": ["ONE_TO_MANY", "MANY_TO_MANY", "ONE_TO_ONE"]
//            },
//            "superlevelName": {
//                "type": "string"
//            },
//            "sublevelName": {
//                "type": "string"
//            }
//        },
//        "required": ["type", "superlevelName", "sublevelName"],
//        "additionalProperties": false
//    }
//},
//"labelGroups": {
//    "type": "array",
//    "items": {
//        "type": "object",
//        "properties": {
//            "name": {
//                "type": "string"
//            },
//            "values": {
//                "type": "array",
//                "items": {
//                    "type": "string"
//                }
//            }
//        }
//    }
//},
    
    
 private EMUwebAppConfig emuWebAppConfig=new EMUwebAppConfig();
 
 @XmlElement(name="EMUwebAppConfig")
 public EMUwebAppConfig getEMUwebAppConfig() {
        return emuWebAppConfig;
    }

    public void setEMUwebAppConfig(EMUwebAppConfig emuWebAppConfig) {
        this.emuWebAppConfig = emuWebAppConfig;
    }

public static void main(String[] args){
   
         Map<String, String> jaxbEclipseLinkPropsmap=new HashMap<String, String>();
         jaxbEclipseLinkPropsmap.put("javax.xml.bind.context.factory","org.eclipse.persistence.jaxb.JAXBContextFactory");
         try {
            JAXBContext jaxbContext=org.eclipse.persistence.jaxb.JAXBContextFactory.createContext(new Class[]{EmuDB.class},jaxbEclipseLinkPropsmap);
            EmuDB emuDB=new EmuDB();
            emuDB.setName("Test");
            emuDB.setUuid(UUID.randomUUID());
            emuDB.setEMUwebAppConfig(EMUwebAppConfig.defaultWithDefaultPerspective());
            Marshaller m=jaxbContext.createMarshaller();

            m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, true);
            m.setProperty("eclipselink.media-type", "application/json");
            m.marshal(emuDB, System.out);
        } catch (JAXBException e) {
            e.printStackTrace();
        }
 }
 
}
