/*
 * Date  : Jan 19, 2012
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */
 
package ips.apps.speechrecorder.startstopsignal;

import java.net.URL;

import ipsk.apps.speechrecorder.monitor.StartStopSignal;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;
import ipsk.util.services.ServiceDescriptor;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class AmpelmaennchenServiceDescriptor implements ServiceDescriptor{
	
	public static final LocalizableMessage TITLE=new LocalizableMessage("Ampelmaennchen Traffic Lights");
    public static final LocalizableMessage DESCRIPTION=new LocalizableMessage("Ampelmaennchen traffic lights start/stop signal plugin for SpeechRecorder");
    public static final String VENDOR="Institute of Phonetics and Speech processing, Munich";
    public static final Version VERSION=new Version(new int[]{1,2,0});
    
    public LocalizableMessage getTitle() {
        return TITLE;
    }

    public LocalizableMessage getDescription() {
       return DESCRIPTION;
    }

    public String getVendor() {
      return VENDOR;
    }

    public Version getSpecificationVersion() {
        return VERSION;
    }

    public Version getImplementationVersion() {
       return VERSION;
    }

    public Class<?> getServiceClass() {
        return StartStopSignal.class;
    }

    public String getServiceImplementationClassname() {
        return "ips.apps.speechrecorder.startstopsignal.Ampelmaennchen";
    }
    
}
