//    IPS SVG prompt presenter
//    (c) Copyright 2012
//    Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of IPS SVG prompt presenter
//
//
//    IPS SVG prompt presenter is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    IPS SVG prompt presenter is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with IPS SVG prompt presenter.  If not, see <http://www.gnu.org/licenses/>.

 
package ips.prompting;

import ipsk.apps.speechrecorder.prompting.PromptPresenterServiceDescriptor;
import ipsk.text.Version;
import ipsk.util.LocalizableMessage;

import java.net.URL;

/**
 * Service descriptor of SVG prompt presenter.
 * Separate descriptor allows lazy loading. Therefore this class should not reference the presenter or its libraries in any way. 
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 *
 */

public class SVGPromptPresenterServiceDescriptor implements PromptPresenterServiceDescriptor{
    private final static boolean DEBUG=false;
    
    public static final String SVG_MIME_TYPE="image/svg+xml";
    private URL packageURL;
    
    public SVGPromptPresenterServiceDescriptor(){
        super();
        if(DEBUG){
            System.out.println("SVG service descriptor loaded.");
        }
    }
    
    public LocalizableMessage getTitle() {
        return new LocalizableMessage("SVG prompt presenter");
    }

    public LocalizableMessage getDescription() {
        return new LocalizableMessage("Prompts scalable vector graphics (SVG) files using Apache Batik.");
    }

    public String getVendor() {
       return "Institute of Phonetics and Speech processing, Munich";
    }

    public Version getSpecificationVersion() {
        return new Version(new int[]{0,2,0});
    }

    public Version getImplementationVersion() {
        return new Version(new int[]{0,2,0});
    }

    public Class<?> getServiceClass() {
       return ipsk.apps.speechrecorder.prompting.presenter.PromptPresenter.class;
    }
    public String getServiceImplementationClassname() {
        return "ips.prompting.SVGPromptPresenter";
     }

    public String[][] getSupportedMIMETypes() {
        if(DEBUG)System.out.println("SVG MIME types queried.");
        String[] mType=new String[]{SVG_MIME_TYPE};
        return new String[][]{mType};
    }

    public URL getPackageURL() {
        return packageURL;
    }

    public void setPackageURL(URL packageURL) {
        this.packageURL = packageURL;
    }
   

}
