//    Speechrecorder
//    (c) Copyright 2012-2020
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.monitor;

import javax.swing.JComponent;
import javax.swing.JPanel;

/**
 * RecMonitor displays a vertical panel with a traffic light to monitor the 
 * recording. A red light means that no speech is recorded, yellow is displayed
 * when the recording is about to begin or has ended, and a green light indicates
 * that the speaker may speak.
 *
 * @author Christoph Draxler
 */

public class RecMonitor extends JPanel {

   
	private static final long serialVersionUID = 1L;
	private StartStopSignal monitorPlugin;
    

	/**
	 * RecMonitor consists of six image files, three lights
	 * of the traffic light either on or off. The images are organized in a 
	 * vertical box layout.
	 */
	public RecMonitor(){
		super();
	}
    
	public void setStartStopSignal(StartStopSignal startStopSignal){
	    
	    monitorPlugin=startStopSignal;
	    
	    removeAll();
	    if(monitorPlugin!=null){
	    	JComponent jc=monitorPlugin.getComponent();
	    	if(jc!=null) {
	    		add(jc);
	    	}
	    }
	    repaint();
	}
	
	
	public void setStartStopSignalStatus(StartStopSignal.State status){
		if(monitorPlugin!=null){
			monitorPlugin.setStatus(status);
		}
	}
  
}