//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.monitor.plugins;

import ipsk.apps.speechrecorder.monitor.BorderStartStopSignal;
import ipsk.apps.speechrecorder.monitor.StartStopSignal;

import java.awt.Container;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Color;

import javax.swing.JComponent;
import javax.swing.border.Border;

public class SimpleBorderStartStopSignal implements BorderStartStopSignal {

	private static final long serialVersionUID = 1L;
	
	private static final int BORDER_WIDTH_PERCENT=2;
	private static final int BORDER_WIDTH_MIN_PIXEL=2;
	
	private Container container;
	private BorderImpl border;
	
	public static class BorderImpl implements Border{
		private State status=State.OFF;
		private Insets insets;
		private int borderWidthCached=BORDER_WIDTH_MIN_PIXEL;
		
		public BorderImpl() {
			super();
		
			// fixed insets for now
			insets=new Insets(BORDER_WIDTH_MIN_PIXEL,BORDER_WIDTH_MIN_PIXEL,BORDER_WIDTH_MIN_PIXEL,BORDER_WIDTH_MIN_PIXEL);
			//insets=new Insets(0,0,0,0);
		}
		
		  public void setStatus(State status) {
		        this.status=status;
		   
		    }
		  
		@Override
		public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
			//System.out.println("paintBorder c: "+c+" "+x+","+y+" "+width+"x"+height);
			update(c);
			java.awt.Color color=Color.LIGHT_GRAY;
			if(State.OFF.equals(status)) {
				color=Color.LIGHT_GRAY;
			}else if(State.IDLE.equals(status)) {
				color=Color.RED;
			}else if(State.PRERECORDING.equals(status)) {
				color=Color.ORANGE;
			}else if(State.RECORDING.equals(status)) {
				color=Color.GREEN;
			}else if(State.POSTRECORDING.equals(status)) {
				color=Color.ORANGE;
			}
			
			Graphics2D g2=(Graphics2D)g;
			g2.setColor(color);
	        g2.fillRect(x, y, width,borderWidthCached);
	        g2.fillRect(x, y+height-borderWidthCached, width,borderWidthCached);
	        g2.fillRect(x,y,borderWidthCached,height);
	        g2.fillRect(x+width-borderWidthCached,y,borderWidthCached,height);
			
		}
		
		public void update(Component c) {;
			//System.out.println("Update c: "+c);
			int compHeight=c.getHeight();
			int borderWith=compHeight*BORDER_WIDTH_PERCENT/100;
			
			if(borderWidthCached!=borderWith) {
				borderWidthCached=borderWith;
				insets=new Insets(borderWith,borderWith,borderWith,borderWith);
				//insets=new Insets(0,0,0,0);
				//System.out.println("Updated insets: "+borderWith);
			}
		}

		@Override
		public Insets getBorderInsets(Component c) {
			update(c);
			
			return insets;
		}

		@Override
		public boolean isBorderOpaque() {
			
			return true;
		}
		
	}

	public SimpleBorderStartStopSignal() {
		super();
		border= new BorderImpl();
	}
	
    public JComponent getComponent() {
       return null;
    }


    public void setStatus(State status) {
        border.setStatus(status);
        container.repaint();
    }
	

	@Override
	public Border getBorder(Container cont) {
		container=cont;
		return border;
	}
    

}