//    Speechrecorder
// 	  (c) Copyright 2014-2020
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.annotation.auto;

import java.io.IOException;
import java.util.Collection;
import java.util.List;

import ips.annot.autoannotator.AutoAnnotationServiceDescriptor;
import ips.annot.autoannotator.AutoAnnotator;
import ips.annot.model.PredefinedLevelDefinition;
import ipsk.util.dependency.DependencyResolver;
import ipsk.util.services.ServiceDescriptorsInspector;

/**
 * @author klausj
 *
 */
public class AutoAnnotationPluginManager extends ServiceDescriptorsInspector<AutoAnnotationServiceDescriptor,AutoAnnotator> {

	private DependencyResolver<AutoAnnotationServiceDescriptor,PredefinedLevelDefinition> dependencyResolver;
	private List<AutoAnnotationServiceDescriptor> autoAnnotatorServiceDescriptors=null;

    /**
	 * @return the autoAnnotatorServiceDescriptors
	 */
	public List<AutoAnnotationServiceDescriptor> getAutoAnnotatorServiceDescriptors() {
		if(autoAnnotatorServiceDescriptors==null){
			try {
				autoAnnotatorServiceDescriptors=getTypedServiceDescriptors(AutoAnnotationServiceDescriptor.class);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		return autoAnnotatorServiceDescriptors;
	}
	
    public AutoAnnotationPluginManager() {
        super(AutoAnnotator.class);
        dependencyResolver=new DependencyResolver<AutoAnnotationServiceDescriptor,PredefinedLevelDefinition>();
        
    }
    
    public boolean checkDependencies(List<AutoAnnotationServiceDescriptor> activatedPlugins,AutoAnnotationServiceDescriptor aasd){
    	return dependencyResolver.isResolvable(activatedPlugins,aasd);
    }
    
    	public List<AutoAnnotationServiceDescriptor> resolve(Collection<AutoAnnotationServiceDescriptor> aads){
    		return dependencyResolver.resolve(aads);
    	}

}
