//    Speechrecorder
//    (c) Copyright 2009-2020
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

/*
 * Date  : Jun 24, 2004
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.apps.speechrecorder.config;

import ipsk.apps.speechrecorder.SpeechRecorder;

import java.awt.event.ActionListener;

import javax.swing.JComboBox;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 * 
 */
public class FormatterView extends JComboBox<Formatter> implements ActionListener{

    public FormatterView(Formatter p) {
        this();

        setFormatter(p);
        
        
    }

    
    public FormatterView() {
        super();
        for(int i=0;i<SpeechRecorder.LOG_FORMATTERS.length;i++){
            addItem(SpeechRecorder.LOG_FORMATTERS[i]);
        }
        setSelectedIndex(0);
       
    }


    public void setFormatter(Formatter f){
        setSelectedItem(f);
    }
        
    public Formatter getFormatter(){
        return (Formatter)getSelectedItem();
        
    }
    
    
    

}
