//    Speechrecorder
//    (c) Copyright 2009-2020
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

/*
 * Date  : Jun 24, 2004
 * Author: K.Jaensch, klausj@phonetik.uni-muenchen.de
 */

package ipsk.apps.speechrecorder.config.ui;

import ipsk.apps.speechrecorder.SpeechRecorder;
import ipsk.apps.speechrecorder.config.Handler;
import ipsk.apps.speechrecorder.config.HandlerView;
import ipsk.apps.speechrecorder.config.Logger;
import ipsk.apps.speechrecorder.config.LoggingConfiguration;
import ipsk.swing.TitledPanel;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Vector;

import javax.swing.JCheckBox;
import javax.swing.JPanel;

/**
 * @author K.Jaensch, klausj@phonetik.uni-muenchen.de
 * 
 */
public class LoggingConfigurationView extends JPanel implements ActionListener {

	private static final long serialVersionUID = 1L;

	private GridBagConstraints c = new GridBagConstraints();

    protected TitledPanel handlerPanel;

    protected TitledPanel loggerPanel;

    private JCheckBox[] enableCheckBoxes = new JCheckBox[0];

    private Logger[] displayedLogger;
    private Handler[] displayedHandlers;
    
    private LoggerView[] loggerViews;
    private HandlerView[] handlerViews;

    public LoggingConfigurationView() {
        super(new GridBagLayout());
        c.insets = new Insets(2, 5, 2, 5);

        c.gridx = 0;
        c.gridy = 0;
        c.anchor = GridBagConstraints.NORTH;
        c.weighty = 1.0;
        handlerPanel = new TitledPanel("Log-Handler");
        handlerPanel.setLayout(new GridBagLayout());
        add(handlerPanel, c);
        loggerPanel = new TitledPanel("Logger");
        loggerPanel.setLayout(new GridBagLayout());
        c.gridy++;
        add(loggerPanel, c);
        
        displayedHandlers=SpeechRecorder.DEF_LOG_HANDLERS;
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        handlerViews=new HandlerView[displayedHandlers.length];
        for (int i = 0; i < displayedHandlers.length; i++) {
            HandlerView hv = new HandlerView(SpeechRecorder.DEF_LOG_HANDLERS[i]);
            handlerViews[i]=hv;
            handlerPanel.add(hv, c);
            c.gridy++;
        }
        
        displayedLogger=SpeechRecorder.AVAIL_LOGGERS;
        enableCheckBoxes = new JCheckBox[displayedLogger.length];
        loggerViews=new LoggerView[displayedLogger.length];
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        for (int i = 0; i < displayedLogger.length; i++) {
            c.gridx = 0;
            JCheckBox enableBox = new JCheckBox();
            enableBox.addActionListener(this);
            enableCheckBoxes[i] = enableBox;

            loggerPanel.add(enableCheckBoxes[i], c);
            LoggerView lv = new LoggerView();
            loggerViews[i]=lv;
            lv.setEnabled(false);
            lv.setLogger(displayedLogger[i]);
            c.gridx++;
            loggerPanel.add(lv, c);
            c.gridy++;
        }
    }

    public void setLoggingConfiguration(
            LoggingConfiguration loggingConfiguration) {
        Logger[] logs = loggingConfiguration.getLogger();
        for (int i = 0; i < displayedLogger.length; i++) {
            loggerViews[i].setEnabled(false);
            for (int j = 0; j < logs.length; j++) {
                if (displayedLogger[i].getName().equals(logs[j].getName())) {
                    loggerViews[i].setLogger(logs[i]);
                    loggerViews[i].setEnabled(true);
                    enableCheckBoxes[i].setSelected(true);
                    break;
                }
            }
        }
        setDependencies();
    }
    
    public void applyValues(LoggingConfiguration l){
        Vector<Logger> newLgs = new Vector<Logger>();
        ArrayList<Handler> newHandlers=new ArrayList<Handler>();
        for (int i = 0; i < displayedLogger.length; i++) {
            if (enableCheckBoxes[i].isSelected()) {
                loggerViews[i].applyValues(displayedLogger[i]);
                newLgs.add(displayedLogger[i]);
                String handlerName=displayedLogger[i].getHandlerName();
                for(int j=0;j<displayedHandlers.length;j++){
                    if(handlerName.equals(displayedHandlers[j].getName())){
                            handlerViews[j].applyValues(displayedHandlers[j]);
                            newHandlers.add(displayedHandlers[j]);
                    }
                }
               
                
            }else{
                
            }
        }
        l.setHandler((Handler[])newHandlers.toArray(new Handler[0]));
        l.setLogger((Logger[]) (newLgs.toArray(new Logger[0])));

    }

    private void setDependencies(){
        for(int i=0;i<enableCheckBoxes.length;i++){
            loggerViews[i].setEnabled(enableCheckBoxes[i].isSelected());
        }
    }
    
    public void actionPerformed(ActionEvent arg0) {
        setDependencies();

    }

   

   

}
