//    Speechrecorder
// 	  (c) Copyright 2017-2020
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import java.awt.Font;

import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;


/**
 * @author klausj
 *
 */
public class PromptStyleContext extends StyleContext {
	
	public PromptStyleContext(Font defaultPromptFont) {
		super();
		int defFontSize=12;
		 if(defaultPromptFont!=null){
			 defFontSize=defaultPromptFont.getSize();
			
		 }else {
			 
		 }
		 
		 
		 StyleContext.NamedStyle defStyle=new StyleContext.NamedStyle();
		 // HTML 4 default p margin 1.12 em 0
		 // points and pixels are equal in Java
		 float space =1.12f*(float)defFontSize;
		 
		 StyleConstants.setSpaceAbove(defStyle,space);
		 StyleConstants.setSpaceBelow(defStyle,space);
		 StyleConstants.setAlignment(defStyle, StyleConstants.ALIGN_CENTER);
		 addStyle(DEFAULT_STYLE, defStyle);
	
		 if(defaultPromptFont!=null){
		     
		     int defFontStyle=defaultPromptFont.getStyle();
		     
		     
		     defStyle.addAttribute(StyleConstants.FontFamily, defaultPromptFont.getFamily());
		     defStyle.addAttribute(PromptStyledDocument.STYLE_ATTR_DEFAULT_FONTSIZE,defFontSize);
		     defStyle.addAttribute(StyleConstants.FontSize, defFontSize);
		     defStyle.addAttribute(StyleConstants.Bold,(defFontStyle & java.awt.Font.BOLD)>0);
		     defStyle.addAttribute(StyleConstants.Italic,(defFontStyle & java.awt.Font.ITALIC)>0);
		 }
		 
	}
	
	public PromptStyleContext() {
        this(null);
    }

}
