//    Speechrecorder
// 	  (c) Copyright 2017
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.



package ipsk.apps.speechrecorder.script.ui.prompt.styled;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.Utilities;
import javax.swing.text.AbstractDocument.DefaultDocumentEvent;
import javax.swing.text.DefaultStyledDocument.ElementBuffer;
import javax.swing.text.DefaultStyledDocument.ElementSpec;

import ipsk.awt.ColorUtils;
import ipsk.db.speech.script.prompt.doc.Block;
import ipsk.db.speech.script.prompt.doc.Body;
import ipsk.db.speech.script.prompt.doc.Linebreak;
import ipsk.db.speech.script.prompt.doc.P;
import ipsk.db.speech.script.prompt.doc.PromptDoc;
import ipsk.db.speech.script.prompt.doc.Text;
import ipsk.db.speech.script.prompt.doc.TextFormatElement;
import ipsk.db.speech.script.prompt.doc.Font.FontSize;
import ipsk.text.ParserException;




/**
 * @author klausj
 *
 */
public class PromptStyledDocument extends javax.swing.text.DefaultStyledDocument{

	// Element name attribute for line breaks (without new paragraph)
	public static String LINE_BREAK_ELEMENT_NAME= "linebreakelement";
	
	// Mark element as "real" elements to be shown in the prompt viewer
	// Workaround for the fact that Swing always appends an additional paragraph to the document, likely for editing
	// This additional paragraph causes the prompt not to be perfectly vertically centered in the prompt viewer
	// We mark the document paragraphs with this attribute (Boolean true value) to filter the appended paragraph from the view in the ViewFactory of PromptDocEditorKit
	public static String VIEW_ELEMENT_NAME= "viewelement";
	
	// We need to store the default font size somewhere, since the font size attribute might differ 
	public static String STYLE_ATTR_DEFAULT_FONTSIZE="defaultFontSize";
	
	// We need to store the virtual font size somewhere, since the font size attribute might differ 
	public static String STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE="fontSizeRelativeOrAbsolute";

	// We need to store if a virtual scale box should be used
      public static String STYLE_ATTR_USE_VIRTUAL_SCALE_BOX="useVirtualScaleBox";
      public static String STYLE_ATTR_VIRTUAL_HEIGHT="virtualHeight";
	
	  protected AbstractElement createDefaultRoot_Dis() {
	       
	        writeLock();
	        
	        // Root section element
	        BranchElement section = new SectionElement();
	        // Paragraph
	        BranchElement paragraph = new BranchElement(section, null);
	        // Line section element
	        SimpleAttributeSet sAttrSet=new SimpleAttributeSet(getStyle(StyleContext.DEFAULT_STYLE));
            sAttrSet.addAttribute(AbstractDocument.ElementNameAttribute, AbstractDocument.SectionElementName);
	        BranchElement lineSection = new BranchElement(paragraph,sAttrSet);
	        // Line branch element
	        BranchElement lineBranch = new BranchElement(lineSection, null);
	        // Dummy text element
	        LeafElement brk = new LeafElement(lineBranch, null, 0, 1);
	        
	        Element[] buff = new Element[1];
	        buff[0] = brk;
	        lineBranch.replace(0, 0, buff);
	        buff[0]=lineBranch;
	        lineSection.replace(0,0,buff);
	        buff[0]=lineSection;
	        paragraph.replace(0,0,buff);
	        buff[0] = paragraph;
	        section.replace(0, 0, buff);
	        
	        writeUnlock();
	        return section;
	    }
	
	  protected AbstractElement createDefaultRoot() {
	    return super.createDefaultRoot();
	  }

	public class PromptDocElement extends javax.swing.text.DefaultStyledDocument.SectionElement{
		
		public PromptDocElement() {
			super();
		}
		
	}
	
	public class ParagraphElement extends javax.swing.text.DefaultStyledDocument.BranchElement{
		
		public ParagraphElement(Element parent,AttributeSet  attrSet) {
			super(parent,attrSet);
		}
		
	}
	
	public class TextFragmentElement extends javax.swing.text.DefaultStyledDocument.LeafElement{
		
		public TextFragmentElement(Element parent,AttributeSet attrSet,int offs1,int offs2) {
			super(parent,attrSet,offs1,offs2);
		}
	}
	
	public class LineBreakElement extends javax.swing.text.DefaultStyledDocument.LeafElement{
		public LineBreakElement(Element parent,int offs1,int offs2) {
			super(parent,new SimpleAttributeSet(),offs1,offs2);
			addAttribute(NameAttribute, LINE_BREAK_ELEMENT_NAME);
			addAttribute(ElementNameAttribute, LINE_BREAK_ELEMENT_NAME);
		
		}
	}
	
	
	private PromptDoc promptDoc;

    /**
     * 
     */
    public PromptStyledDocument() {
        super();
    }
    
    public void setCharacterAttributes(int offset,int length,AttributeSet s,boolean replace){
    	super.setCharacterAttributes(offset, length, s, replace);
    }

    public Element getCharacterElement(int pos) {
        Element e=super.getCharacterElement(pos);
        return e;
    }

    public String getText(int offset,
            int length)
              throws BadLocationException{
    	String s=super.getText(offset, length);
    	return s;
    }
    
    public void getText(int offset,
            int length,
            Segment txt)
              throws BadLocationException{
    	
    	super.getText(offset, length, txt);
    }

    private void toContentElems(List<ElementSpec> elSpecList,List<TextFormatElement> ftc,MutableAttributeSet as) throws ParserException{
   
        int chSz=ftc.size();
        
        for(int i=0;i<chSz;i++){
            TextFormatElement ft=ftc.get(i);
           
            SimpleAttributeSet saSet=new SimpleAttributeSet(getStyle(StyleContext.DEFAULT_STYLE));
            StyleConstants.setSpaceAbove(saSet,0.0f);
       	 	StyleConstants.setSpaceBelow(saSet,0.0f);
           
            Text text=null;
            ipsk.db.speech.script.prompt.doc.Font f=null;
            String t=null;
            
            
            if(ft instanceof  ipsk.db.speech.script.prompt.doc.Font){
                f=(ipsk.db.speech.script.prompt.doc.Font)ft;
                text=f.getText();
                t=text.getText();
            }else if(ft instanceof Text){
                text=(Text)ft;
                t=text.getText();
            }else if(ft instanceof Linebreak) {
            		// New line:
            	  // Add a newline character
            	SimpleAttributeSet brkSet=new SimpleAttributeSet();
            	brkSet.addAttribute(ElementNameAttribute, LINE_BREAK_ELEMENT_NAME);
                ElementSpec nlTg=new ElementSpec(brkSet, ElementSpec.ContentType, "\r".toCharArray(), 0,1);
                elSpecList.add(nlTg);
              
            }
           
            if(text!=null) {
            	String de=text.getDecoration();
            	if(ipsk.db.speech.script.prompt.doc.Text.UNDERLINE.equals(de)){
            		StyleConstants.setUnderline(saSet, true);
            	}else if(ipsk.db.speech.script.prompt.doc.Text.LINE_THROUGH.equals(de)){
            		StyleConstants.setStrikeThrough(saSet, true);
            	}else if(ipsk.db.speech.script.prompt.doc.Text.NONE.equals(de)){
            		StyleConstants.setUnderline(saSet, false);
            	}
            	String co=text.getColor();
            	if(co!=null){
            		Color c=ColorUtils.stringToColor(co);
            		if(c!=null){
            			StyleConstants.setForeground(saSet,c);
            		}
            	}
            }
            if(f!=null){
                String si=f.getSize();
                if(si!=null){
                    Style defStyle=getStyle(StyleContext.DEFAULT_STYLE);
                    Object defFontSize=defStyle.getAttribute(StyleConstants.FontSize);
                    
                    if(defFontSize instanceof Number){
                        Number defFontSizeNumber=(Number)defFontSize;
                        FontSize fs=f.fontSize();
                        if(fs!=null) {
                        	saSet.addAttribute(STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE, fs);
                        }
                        double absSize=f.toRealFontSize(defFontSizeNumber.doubleValue());
                        StyleConstants.setFontSize(saSet, (int) absSize);
                        
                    }
                }
                String st=f.getStyle();
                if(ipsk.db.speech.script.prompt.doc.Font.ITALIC.equals(st)){
                    StyleConstants.setItalic(saSet, true);
                }else if(ipsk.db.speech.script.prompt.doc.Font.NORMAL.equals(st)){
                    StyleConstants.setBold(saSet, false);
                }
                String we=f.getWeight();
                if(ipsk.db.speech.script.prompt.doc.Font.BOLD.equals(we)){
                    StyleConstants.setBold(saSet, true);
                }else if(ipsk.db.speech.script.prompt.doc.Font.NORMAL.equals(we)){
                    StyleConstants.setBold(saSet, false);
                }
            }

            if(t!=null){
            	 int tlen=t.length();
              ElementSpec txtTg=new ElementSpec(saSet, ElementSpec.ContentType, t.toCharArray(), 0,tlen);
              elSpecList.add(txtTg);
             
                
            }
        }
        // Add a newline character
        SimpleAttributeSet saSet=new SimpleAttributeSet(getStyle(StyleContext.DEFAULT_STYLE));
        ElementSpec nlTg=new ElementSpec(saSet, ElementSpec.ContentType, "\n".toCharArray(), 0,1);
        elSpecList.add(nlTg);

        return;
    }
    
    public PromptStyledDocument(StyleContext styleCtx,PromptDoc promptDoc) throws ParserException{
    	super(styleCtx);
    	this.promptDoc=promptDoc;
    	build();
//        System.out.println("Dump after constructor:\n");
//        dump(System.out);
    }
    private void build() throws ParserException {
    	Body body=promptDoc.getBody();
    	if(body!=null) {

    		List<ElementSpec> elspecs=new ArrayList<ElementSpec>();

    		SimpleAttributeSet sAttrSet=new SimpleAttributeSet(getStyle(StyleContext.DEFAULT_STYLE));
    		sAttrSet.addAttribute(AbstractDocument.ElementNameAttribute, AbstractDocument.SectionElementName);
    		ElementSpec s=new ElementSpec(sAttrSet, ElementSpec.StartTagType);
    		elspecs.add(s);

    		List<Block> blocks=body.getBlocks();

    		int pCnt=blocks.size();

    		if(pCnt>0) {

    			for(int pi=0;pi<pCnt;pi++){

    				Block b=blocks.get(pi);

    				SimpleAttributeSet ppAttrSet=new SimpleAttributeSet(getStyle(StyleContext.DEFAULT_STYLE));
    				ppAttrSet.addAttribute(VIEW_ELEMENT_NAME, true);
    				ElementSpec spTg=new ElementSpec(ppAttrSet, ElementSpec.StartTagType);
    				elspecs.add(spTg);

    				if(b instanceof P) {
    					P p=(P)b;
    					SimpleAttributeSet pAttrSet=new SimpleAttributeSet(getStyle(StyleContext.DEFAULT_STYLE));

    					toContentElems(elspecs, p.getTexts(), pAttrSet);
    				}
    				// end of paragraph

    				ElementSpec epTg=new ElementSpec(ppAttrSet, ElementSpec.EndTagType);
    				elspecs.add(epTg);
    			}
    		}else {
    			// editorkit requires dummy
    			SimpleAttributeSet ppAttrSet=new SimpleAttributeSet(getStyle(StyleContext.DEFAULT_STYLE)); 
    			ElementSpec spTg=new ElementSpec(ppAttrSet, ElementSpec.StartTagType);
    			elspecs.add(spTg);

    			ElementSpec stTg=new ElementSpec(null, ElementSpec.StartTagType);
    			elspecs.add(stTg);

    			// end line (paragraph) element 
    			ElementSpec pETg=new ElementSpec(null, ElementSpec.EndTagType);
    			elspecs.add(pETg);


    			// end of paragraph
    			ElementSpec speTg=new ElementSpec(ppAttrSet.copyAttributes(), ElementSpec.EndTagType);
    			elspecs.add(speTg);

    		}
    	
    		ElementSpec seTg=new ElementSpec(sAttrSet, ElementSpec.EndTagType);
    		elspecs.add(seTg);

    		create(elspecs.toArray(new ElementSpec[elspecs.size()]));
    		//        System.out.println("Dump after doc insert:\n");
    		//        dump(System.out);
    	}
    	}
    
    public void insertLineBreak(int offset) throws BadLocationException {
    	MutableAttributeSet brkSet=new SimpleAttributeSet();
    	brkSet.addAttribute(ElementNameAttribute, LINE_BREAK_ELEMENT_NAME);
    	insertString(offset,"\r",brkSet);
    }
    
    protected void insertUpdate(DefaultDocumentEvent chng, AttributeSet attr) {
    	if(attr !=null) {
    		Object elName=attr.getAttribute(AbstractDocument.ElementNameAttribute);
    	
        if( elName!=null && LINE_BREAK_ELEMENT_NAME.equals(elName)) {
//        	System.out.println("Ignored insert update!");
        	
        	
            int offset = chng.getOffset();
            int length = chng.getLength();
          
            Element paragraph = getParagraphElement(offset + length);
            AttributeSet pattr = paragraph.getAttributes();
            // Character attributes should come from actual insertion point.
            Element pParagraph = getParagraphElement(offset);
            Element run = pParagraph.getElement(pParagraph.getElementIndex
                                                (offset));
            int endOffset = offset + length;
            boolean insertingAtBoundry = (run.getEndOffset() == endOffset);
            AttributeSet cattr = run.getAttributes();

            try {
                Segment s = new Segment();
                Vector<ElementSpec> parseBuffer = new Vector<ElementSpec>();
              
                boolean insertingAfterNewline = false;
                //short lastStartDirection = ElementSpec.OriginateDirection;
                
                // If not inserting after a new line, pull the attributes for
                // new paragraphs from the paragraph under the insertion point.
                if(!insertingAfterNewline)
                    pattr = pParagraph.getAttributes();

                getText(offset, length, s);
                char[] txt = s.array;
                int n = s.offset + s.count;
                int lastOffset = s.offset;

                for (int i = s.offset; i < n; i++) {
                    if (txt[i] == '\n') {
                        int breakOffset = i + 1;
                        parseBuffer.addElement(
                            new ElementSpec(attr, ElementSpec.ContentType,
                                                   breakOffset - lastOffset));
                        // DO NOT insert paragraph here
                        lastOffset = breakOffset;
                    }
                }
                if (lastOffset < n) {
                    parseBuffer.addElement(
                        new ElementSpec(attr, ElementSpec.ContentType,
                                               n - lastOffset));
                }

                ElementSpec first = parseBuffer.firstElement();

                int docLength = getLength();

                // Check for join previous of first content.
                if(first.getType() == ElementSpec.ContentType &&
                   cattr.isEqual(attr)) {
                    first.setDirection(ElementSpec.JoinPreviousDirection);
                }


                // Do a JoinNext for last spec if it is content, it doesn't
                // already have a direction set, no new paragraphs have been
                // inserted or a new paragraph has been inserted and its join
                // direction isn't originate, and the element at endOffset
                // is a leaf.
                if(insertingAtBoundry && endOffset < docLength) {
                    ElementSpec last = parseBuffer.lastElement();
                    if(last.getType() == ElementSpec.ContentType &&
                       last.getDirection() != ElementSpec.JoinPreviousDirection &&
                       ( (paragraph == pParagraph ||
                                                   insertingAfterNewline))) {
                        Element nextRun = paragraph.getElement(paragraph.
                                               getElementIndex(endOffset));
                        // Don't try joining to a branch!
                        if(nextRun.isLeaf() &&
                           attr.isEqual(nextRun.getAttributes())) {
                            last.setDirection(ElementSpec.JoinNextDirection);
                        }
                    }
                }
                ElementSpec[] spec = new ElementSpec[parseBuffer.size()];
                parseBuffer.copyInto(spec);
                buffer.insert(offset, length, spec, chng);
            } catch (BadLocationException bl) {
            }

        }else {
        	super.insertUpdate(chng, attr);
        }
        
        }else {
        	super.insertUpdate(chng, attr);
        }
    }
    
    
    private void updateFontSizes() throws BadLocationException, ParserException {
    	remove(0, getLength());
    	build();
    }
    
    public void setUseVirtualScaleBox(boolean useVirtualScaleBox) {
    	Style defStyle=getStyle(StyleContext.DEFAULT_STYLE);
    	defStyle.addAttribute(STYLE_ATTR_USE_VIRTUAL_SCALE_BOX, useVirtualScaleBox);
    	try {
			updateFontSizes();
		} catch (BadLocationException | ParserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
    }
    
    public boolean getUseVirtualScaleBox() {
    	boolean uvsb=true; // default
    	Style defStyle=getStyle(StyleContext.DEFAULT_STYLE);
    	Object useVsb=defStyle.getAttribute(STYLE_ATTR_USE_VIRTUAL_SCALE_BOX);
    	// default: true
    	if(Boolean.FALSE.equals(useVsb)){
    		uvsb=false;
    	}
    	return uvsb;
    }
    
    
    public PromptDoc toPromptFormat() {
    	//System.out.println("Len: "+getLength());
    	readLock();
    	
    	// default Style
    	//Style defStyle=getStyle(StyleContext.DEFAULT_STYLE);
    	
    	 PromptDoc pr=new PromptDoc();
    	
//    	Object useVsb=defStyle.getAttribute(STYLE_ATTR_USE_VIRTUAL_SCALE_BOX);
//    	// default: true
//    	if(Boolean.FALSE.equals(useVsb)){
//    		ipsk.db.speech.script.prompt.Style style=new ipsk.db.speech.script.prompt.Style();
//    		style.setUseVirtualViewBox(false);
//    		pr.setStyle(style);
//    	}
//    	
    	List<Block> prParagraphs=new ArrayList<>();
    	Element rootElem=getDefaultRootElement();
    	// Root section
    	int pCnt=rootElem.getElementCount();
    	for(int i=0;i<pCnt;i++){
    		Element pe=rootElem.getElement(i);
    		P p=new P();
    		prParagraphs.add(p);

    		int pChCnt=pe.getElementCount();
    		for(int pci=0;pci<pChCnt;pci++){
    			// Paragraph
    			// Text fragment element
    			Element pChE=pe.getElement(pci);

    			if(pChE.isLeaf()){

    				// pChE is a formatted content element
    				// convert it to a SpeechDb hierarchy
    				AttributeSet attrSet=pChE.getAttributes();

    				Object nmAttr=attrSet.getAttribute(AbstractDocument.ElementNameAttribute);
    				if(LINE_BREAK_ELEMENT_NAME.equals(nmAttr)) {
    					Linebreak nl=new Linebreak();
    					p.getTexts().add(nl);
    				}else {

    					ipsk.db.speech.script.prompt.doc.Font fe=null;
    					ipsk.db.speech.script.prompt.doc.Text te=new Text();


    					if(attrSet.isDefined(StyleConstants.Italic)){
    						// font element required
    						fe=new ipsk.db.speech.script.prompt.doc.Font();
    						Object italicAttr=attrSet.getAttribute(StyleConstants.Italic);
    						if(Boolean.TRUE.equals(italicAttr)){
    							fe.setStyle(ipsk.db.speech.script.prompt.doc.Font.ITALIC);
    						}else{
    							fe.setStyle(ipsk.db.speech.script.prompt.doc.Font.NORMAL); 
    						}
    					}
    					if(attrSet.isDefined(StyleConstants.Bold)){
    						if(fe==null){
    							// font element required
    							fe=new ipsk.db.speech.script.prompt.doc.Font();
    						}
    						Object boldAttr=attrSet.getAttribute(StyleConstants.Bold);
    						if(Boolean.TRUE.equals(boldAttr)){
    							fe.setWeight(ipsk.db.speech.script.prompt.doc.Font.BOLD);
    						}else{
    							fe.setWeight(ipsk.db.speech.script.prompt.doc.Font.NORMAL);
    						}
    					}
//    					if(attrSet.isDefined(StyleConstants.FontSize)){
//    						if(fe==null){
//    							// font element required
//    							fe=new ipsk.db.speech.Font();
//    						}
//    						FontSize fs=(FontSize) attrSet.getAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
//    						if(fs!=null) {
//    							fe.setSize(fs.toString());
//    						}else {
//    							Object fsAttr=attrSet.getAttribute(StyleConstants.FontSize);
//    							String fsSizeStr=fsAttr.toString();
//    							fe.setSize(fsSizeStr);
//    						}
//    					}
    					
    					FontSize fs=(FontSize) attrSet.getAttribute(PromptStyledDocument.STYLE_ATTR_FONTSIZE_RELATIVE_OR_ABSOLUTE);
						if(fs!=null) {
							if(fe==null){
    							// font element required
    							fe=new ipsk.db.speech.script.prompt.doc.Font();
    						}
							fe.setSize(fs.toString());
						}
						
    					String decoration=null;

    					if(attrSet.isDefined(StyleConstants.StrikeThrough)){
    						Object stAttr=attrSet.getAttribute(StyleConstants.StrikeThrough);
    						if(Boolean.TRUE.equals(stAttr)){
    							decoration=Text.LINE_THROUGH;
    						}
    					}

    					if(decoration==null && attrSet.isDefined(StyleConstants.Underline)){
    						Object ulAttr=attrSet.getAttribute(StyleConstants.Underline);
    						if(Boolean.TRUE.equals(ulAttr)){
    							decoration=Text.UNDERLINE;
    						}
    					}
    					te.setDecoration(decoration);

    					if(attrSet.isDefined(StyleConstants.Foreground)){
    						Object cAttr=attrSet.getAttribute(StyleConstants.Foreground);
    						if(cAttr instanceof Color){
    							Color c=(Color)cAttr;
    							te.setColor(ColorUtils.colorToString(c));
    						}
    					}

    					if(fe!=null){
    						fe.setText(te);
    					}


    					if(pChE instanceof LeafElement){

    						// get the text of the range
    						LeafElement le=(LeafElement)pChE;
    						int st=le.getStartOffset();
    						int en=le.getEndOffset();
    						String str;
    						try {
    							str = getText(st,en-st);
    							//if(en==pe.getEndOffset()){
    							// remove implied new line
    							str=str.replaceFirst("\n$","");
    							//}
    							if(str.length()>0){
    								te.setText(str);
    								if(fe!=null){
    									p.getTexts().add(fe);
    								}else{
    									p.getTexts().add(te);
    								}
    							}
    						} catch (BadLocationException e) {
    							// TODO Auto-generated catch block
    							e.printStackTrace();
    						}
    					}
    				}
    			}
    		}
    	}

    // remove last empty paragraph
    int prSize=prParagraphs.size();
    Block lastPr=prParagraphs.get(prSize-1);
    if(lastPr.getTexts().size()==0) {
    	prParagraphs.remove(prSize-1);
    }

   
    Body body=new Body();
    pr.setBody(body);
    body.setBlocks(prParagraphs);
    readUnlock();
    return pr;
}


}
