//    Speechrecorder
//    (c) Copyright 2012
// 	  Institute of Phonetics and Speech Processing,
//    Ludwig-Maximilians-University, Munich, Germany
//
//
//    This file is part of Speechrecorder
//
//
//    Speechrecorder is free software: you can redistribute it and/or modify
//    it under the terms of the GNU Lesser General Public License as published by
//    the Free Software Foundation, version 3 of the License.
//
//    Speechrecorder is distributed in the hope that it will be useful,
//    but WITHOUT ANY WARRANTY; without even the implied warranty of
//    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//    GNU Lesser General Public License for more details.
//
//    You should have received a copy of the GNU Lesser General Public License
//    along with Speechrecorder.  If not, see <http://www.gnu.org/licenses/>.

package ipsk.apps.speechrecorder.ui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import ipsk.swing.JDialogPanel;
import ipsk.swing.ZipFileFilter;

public class ExportProjectUIDialog extends JDialogPanel{

   //private JCheckBox exportSessionDataCheckBox;
   private JCheckBox exportConfigAndScriptsOnlyCheckBox;
   private JTextField filePathField;
   private JButton browseButton;
   private JFileChooser fileChooser;
   private File exportFile;
   
	public File getExportFile() {
    return exportFile;
}

public void setExportFile(File exportFile) {
    this.exportFile = exportFile;
    if(exportFile!=null){
        setApplyingEnabled(true);
    }
    String path=exportFile.getAbsolutePath();
    
    filePathField.setText(path);
}

    public ExportProjectUIDialog() {
	    super(JDialogPanel.Options.OK_CANCEL);
	    okButton.setText("Export");
	    setFrameTitle("Export project");
	    setApplyingEnabled(false);
	    JPanel cfgP=new JPanel(new GridBagLayout());
	    GridBagConstraints gc=new GridBagConstraints();
	    Insets ins=new Insets(1,1,1,1);
	    gc.insets=ins;
	    gc.gridx=0;
	    gc.gridy=0;
//        exportSessionDataCheckBox=new JCheckBox("Export session data (speaker database,recording files)");
//        exportSessionDataCheckBox.setSelected(true);
//        gc.gridwidth=2;
//        cfgP.add(exportSessionDataCheckBox,gc);
	    
        exportConfigAndScriptsOnlyCheckBox=new JCheckBox("Export project configuration and scripts with resources only (without speaker database and recording files)");
        exportConfigAndScriptsOnlyCheckBox.setSelected(false);
        gc.gridwidth=2;
        cfgP.add(exportConfigAndScriptsOnlyCheckBox,gc);
        
        gc.gridy++;
        gc.gridwidth=1;
        cfgP.add(new JLabel("ZIP file:"),gc);
        gc.gridx++;
        gc.weightx=2.0;
        gc.fill=GridBagConstraints.HORIZONTAL;
        filePathField=new JTextField(20);
        cfgP.add(filePathField,gc);
        browseButton=new JButton("Browse...");
        gc.gridx++;
        gc.fill=GridBagConstraints.NONE;
        gc.weightx=0.0;
        cfgP.add(browseButton,gc);
        browseButton.addActionListener(this);
        getContentPane().add(cfgP);
	}
	
    public boolean isExportSessionData(){
	    return !exportConfigAndScriptsOnlyCheckBox.isSelected();
	}
	
	
	
	 protected void applyValues(){
	     String path=filePathField.getText();
	     File exportFile=null;
	     if(! "".equals(path)){
	         setExportFile(new File(path));
	         
	     }
	     super.applyValues();
     }

	
	public void actionPerformed(ActionEvent ae) {
        Object src = ae.getSource();
       
        if (src == browseButton) {
            fileChooser = new JFileChooser();
            fileChooser.setFileFilter(new ZipFileFilter());
            fileChooser.setAcceptAllFileFilterUsed(true);
            fileChooser.setSelectedFile(exportFile);
            int res = fileChooser.showDialog(this,"Select");
            if (res == JFileChooser.APPROVE_OPTION) {
                setExportFile(fileChooser.getSelectedFile());
                
            }
        }else{
            super.actionPerformed(ae);
        }

    }

   
	
}
