package ipsk.jsp.taglib.beans.table;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;

import javax.persistence.ManyToMany;
import javax.persistence.OneToMany;
import javax.servlet.ServletContext;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;

import ips.beans.ExtBeanInfo;
import ips.beans.PersistenceIntrospector;
import ips.servlet.http.URLEncoder;
import ipsk.jsp.taglib.beans.BeanProperty;
import ipsk.jsp.taglib.beans.BeanPropertyValueText;
import ipsk.net.EditableURI;
import ipsk.persistence.PersistenceObjectIdentifier;
import ipsk.text.html.HTMLTextEncoder;
import ipsk.webapps.BasicPersistenceBeanController;

public class BeanPropertyTableCol extends BeanTableCol{
	protected String var;
	protected String href;
	protected String queryName;
	protected int maxListLength=0;
	protected String valueCssClass;
	protected int maxTextLength=-1;
	
	protected BeanProperty beanProperty;
	protected ExtBeanInfo beanInfo;
	private PropertyDescriptor pd;
	private Class<?> propType;
	
	//private PropertyDescriptor propertyDescriptor;
	
	public BeanPropertyTableCol(String name,String bundle,String key,String href,int maxListLength,String queryName,String var){
		super(name,bundle,key);
		beanProperty=new BeanProperty(name,bundle,key);
		pd = beanProperty.getPropertyDescriptor();
		propType = pd.getPropertyType();
		this.href=href;
		this.maxListLength=maxListLength;
		this.queryName=queryName;
		this.var=var;
	}
	
	

	public BeanPropertyTableCol(PropertyDescriptor pd,ExtBeanInfo beanInfo) {
		super(pd.getName());
		beanProperty=new BeanProperty(pd);
		this.beanInfo=beanInfo;
		this.pd = beanProperty.getPropertyDescriptor();
		propType = pd.getPropertyType();
	}
	
	public String getVar() {
		return var;
	}

	public void setVar(String var) {
		this.var = var;
	}
	public String getHref() {
		return href;
	}

	public void setHref(String href) {
		this.href = href;
	}

	public String getQueryName() {
		return queryName;
	}

	public void setQueryName(String namedQuery) {
		this.queryName = namedQuery;
	}

	public String getBundle() {
		if(bundle!=null)return bundle;
		return beanProperty.getBundle();
	}

	public String getKey() {
		if(key!=null)return key;
		return beanProperty.getKey();
	}
	
	public String getEncodedHrefUri(Object item) throws JspException,IllegalArgumentException, IllegalAccessException, InvocationTargetException{
		Object idVal =null;
		PropertyDescriptor pd = beanProperty.getPropertyDescriptor();
		try {
			
			boolean linkPossible=false;
			//boolean toOneRelationShip=false;
			PersistenceObjectIdentifier relPoi=null;
			if (href != null) {
				EditableURI uri = new EditableURI(href);
				//Object idVal = beanInfo.getIdValue(item);
				PersistenceObjectIdentifier poi=null;	
					poi=beanInfo.getPersistenceObjectIdentifier(item);

				idVal =poi.getIdObject();
				PropertyDescriptor idPropertyDescriptor = beanInfo.getIdPropertyDescriptor();

				if (queryName != null) {
					uri.appendQuery(BasicPersistenceBeanController.KEY_CMD,
							BasicPersistenceBeanController.CMD_NAMED_QUERY);
					uri.appendQuery(BasicPersistenceBeanController.KEY_QUERY_NAME,
							queryName);
					uri.appendQueryMap(poi.toQueryMap());
				} else {
					if (pd.equals(idPropertyDescriptor)) {
						// The Id property, means the link points to a JSP
						// page using the same entity class
						uri.appendQuery(BasicPersistenceBeanController.KEY_CMD,
								BasicPersistenceBeanController.CMD_VIEW);
						uri.appendQuery(idPropertyDescriptor.getName(),
								idVal);
						linkPossible=true;
					} else {
						String mappedBy = null;
						if (Collection.class.isAssignableFrom(propType)) {

							// Assuming ManyToMany or OneToMany
							uri.appendQuery(BasicPersistenceBeanController.KEY_CMD,
									BasicPersistenceBeanController.CMD_LIST_RELATED);
							Method rm = pd.getReadMethod();

							ManyToMany manyToManyAnno = rm
							.getAnnotation(ManyToMany.class);
							if (manyToManyAnno != null) {
								mappedBy = manyToManyAnno.mappedBy();
							} else {
								OneToMany oneToManyAnno = rm
								.getAnnotation(OneToMany.class);
								if (oneToManyAnno != null) {
									mappedBy = oneToManyAnno.mappedBy();
								}
							}
							uri.appendQueryMap(poi.toQueryMap());
							if (mappedBy != null && !mappedBy.equals("")) {
								uri.appendQuery(BasicPersistenceBeanController.KEY_MAPPEDBY,
										mappedBy);
							} else {
								uri.appendQuery(
										BasicPersistenceBeanController.KEY_RELATED_PROPERTY,
										pd.getName());
							}
							linkPossible=true;
						} else {
							// Assuming ManyToOne or OneToOne
							//toOneRelationShip=true;
							// Get related object
							Method rm=pd.getReadMethod();
							Object relObject=null;
							relObject=rm.invoke(item, new Object[0]);
							
							if(relObject!=null){
									ExtBeanInfo relBeanInfo=PersistenceIntrospector.getPersistenceBeanInfo(relObject.getClass(),true);
									relPoi=relBeanInfo.getPersistenceObjectIdentifier(relObject);

								uri.appendQuery(BasicPersistenceBeanController.KEY_CMD,
										BasicPersistenceBeanController.CMD_VIEW);
								uri.appendQueryMap(relPoi.toQueryMap());
								linkPossible=true;
							}
						}

					}

				}
				if (linkPossible){
					return uri.getUri();	
				}
			}
			
			} catch (IOException ioe) {
				throw new JspException("Error: IOException while creating relationship URI");
			} catch (IntrospectionException e) {
				throw new JspException("Error: Bean Introspection error.");
			}
			return null;
	}
		
	
	public void printTag(PageContext pageContext,Object item) throws JspException {
		printTag(pageContext, beanInfo, item);
	}
	
	public void printTag(PageContext pageContext,Object item,String cssClass) throws JspException {
		printTag(pageContext, beanInfo, item,cssClass,-1);
	}
	
	public void printTag(PageContext pageContext,Object item,String cssClass,int maxTextLength) throws JspException {
		printTag(pageContext, beanInfo, item,cssClass,maxTextLength);
	}
	
	public void printTag(PageContext pageContext,ExtBeanInfo beanInfo,Object item) throws JspException {
		printTag(pageContext, beanInfo, item,null,-1);
	}
	
	public void printTag(PageContext pageContext,ExtBeanInfo beanInfo,Object item,String cssClass,int maxTextLength) throws JspException {

		ServletContext sc=pageContext.getServletContext();
		if (var == null) {
			JspWriter ow = pageContext.getOut();
			try {
				ow.print("<td>");
				String uriStr;

				uriStr=getEncodedHrefUri(item);
				if (uriStr!=null){
					String encodedUrl=URLEncoder.encodeURL(pageContext,uriStr);
					String htmlEncodedUrl=HTMLTextEncoder.encode(encodedUrl);
					ow.println("<a href=\"" + htmlEncodedUrl + "\">");
				}
				String valStr = null;
				BeanPropertyValueText bpvt = new BeanPropertyValueText(
						beanInfo, pageContext,maxListLength);

				try {
					valStr = bpvt.getValueTextRepresentation(item, pd);
				} catch (Exception e) {
					throw new JspException(
							"Could not create bean value string representation: "
									+ e);
				}
				String displayValStr=valStr;
				int valStrLen=valStr.length();
				if(maxTextLength>=0 && valStrLen>maxTextLength) {
					int maxIdx=maxTextLength-3;
					if(maxIdx>=valStrLen) {
						maxIdx=valStrLen-1;
					}
					if(maxIdx<0) {
						maxIdx=0;
					}
					displayValStr=valStr.substring(0, maxIdx)+"...";
					
				}
				String encValStr=HTMLTextEncoder.encode(displayValStr);
				String cssedEncValStr=encValStr;
				if(cssClass!=null) {
					cssedEncValStr="<span class=\""+cssClass+"\">"+encValStr+"</span>";
				}
				ow.print(cssedEncValStr);

				if (href != null && uriStr!=null) {
					if(valStr==null || "".equals(valStr)) {
						// the value is empty but we have a link
						// print a placeholder instead of the value string representation
						ow.print("_");
					}
					ow.print("</a>");
				}
				ow.print("</td>");

			} catch (Exception ioe) {
				String errMsg="Error: IOException while writing cell property";
				if(sc!=null) {
					sc.log(errMsg, ioe);
				}
				throw new JspException(errMsg);
			}
		}
	}



	public BeanProperty getBeanProperty() {
		return beanProperty;
	}



	public int getMaxListLength() {
		return maxListLength;
	}



	public void setMaxListLength(int maxListLength) {
		this.maxListLength = maxListLength;
	}

	public String getValueCssClass() {
		return valueCssClass;
	}

	public void setValueCssClass(String valueCssClass) {
		this.valueCssClass = valueCssClass;
	}


	public void setMaxTextLength(int maxTextLength) {
		this.maxTextLength=maxTextLength;
	}



	public int getMaxTextLength() {
		return maxTextLength;
	}
	
}
